/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ArquivamentoDoc;
import com.touchcomp.basementor.model.vo.ClassificacaoMarketing;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.ProcedenciaSolicitacao;
import com.touchcomp.basementor.model.vo.PropComercialModFichaTec;
import com.touchcomp.basementor.model.vo.PropComercialPessoa;
import com.touchcomp.basementor.model.vo.PropostaComercialItens;
import com.touchcomp.basementor.model.vo.PropostaComercialStatus;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoa;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="PROPOSTA_COMERCIAL")
public class PropostaComercial
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Date dataProposta;
    private Date dataPrevista;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Pessoa pessoa;
    private String observacao;
    private Representante representante;
    private List<PropComercialPessoa> indicantes;
    private List<PropComercialModFichaTec> propComercialModFichaTec;
    private ProcedenciaSolicitacao procedenciaSolicitacao;
    private ClassificacaoMarketing classificacaoMarketing;
    private RelacionamentoPessoa relacionamentoPessoa;
    private Usuario usuario;
    private List<PropostaComercialItens> itensProposta = new ArrayList<PropostaComercialItens>();
    private PropostaComercialStatus propostaComercialStatus;
    private Double valorTotalItens = 0.0;
    private Double valorDesconto = 0.0;
    private Double valorTotal = 0.0;
    private String solucao;
    private ArquivamentoDoc arquivamentoDoc;

    public PropostaComercial() {
        this.propComercialModFichaTec = new ArrayList<PropComercialModFichaTec>();
        this.indicantes = new ArrayList<PropComercialPessoa>();
    }

    @Id
    @Column(name="ID_PROPOSTA_COMERCIAL")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PROPOSTA_COMERCIAL")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PROPOSTA_COMERCIAL_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_PROPOSTA_COMERCIAL_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Column(name="OBSERVACAO", length=500)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @OneToMany(mappedBy="propostaComercial")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<PropComercialPessoa> getIndicantes() {
        return this.indicantes;
    }

    public void setIndicantes(List<PropComercialPessoa> indicantes) {
        this.indicantes = indicantes;
    }

    @OneToMany(mappedBy="propComercial")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<PropComercialModFichaTec> getPropComercialModFichaTec() {
        return this.propComercialModFichaTec;
    }

    public void setPropComercialModFichaTec(List<PropComercialModFichaTec> propComercialModFichaTec) {
        this.propComercialModFichaTec = propComercialModFichaTec;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getObservacao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @JoinColumn(name="ID_REPRESENTANTE", foreignKey=@ForeignKey(name="FK_PROPOSTA_COMERCIAL_REPRESEN"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Representante getRepresentante() {
        return this.representante;
    }

    public void setRepresentante(Representante representante) {
        this.representante = representante;
    }

    @JoinColumn(name="ID_PROCEDENCIA_SOLICITACAO", foreignKey=@ForeignKey(name="FK_PROPOSTA_COMERCIAL_PR_SOL"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ProcedenciaSolicitacao getProcedenciaSolicitacao() {
        return this.procedenciaSolicitacao;
    }

    public void setProcedenciaSolicitacao(ProcedenciaSolicitacao procedenciaSolicitacao) {
        this.procedenciaSolicitacao = procedenciaSolicitacao;
    }

    @JoinColumn(name="ID_CLASSIFICACAO_MARKETING", foreignKey=@ForeignKey(name="FK_PROPOSTA_COMERCIAL_CL_MARK"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ClassificacaoMarketing getClassificacaoMarketing() {
        return this.classificacaoMarketing;
    }

    public void setClassificacaoMarketing(ClassificacaoMarketing classificacaoMarketing) {
        this.classificacaoMarketing = classificacaoMarketing;
    }

    @JoinColumn(name="ID_RELACIONAMENTO_PESSOA", foreignKey=@ForeignKey(name="FK_PROPOSTA_COMERCIAL_REL_PESS"))
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    @ManyToOne(fetch=FetchType.LAZY)
    public RelacionamentoPessoa getRelacionamentoPessoa() {
        return this.relacionamentoPessoa;
    }

    public void setRelacionamentoPessoa(RelacionamentoPessoa relacionamentoPessoa) {
        this.relacionamentoPessoa = relacionamentoPessoa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_PROPOSTA")
    public Date getDataProposta() {
        return this.dataProposta;
    }

    public void setDataProposta(Date dataProposta) {
        this.dataProposta = dataProposta;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_PREVISTA")
    public Date getDataPrevista() {
        return this.dataPrevista;
    }

    public void setDataPrevista(Date dataPrevista) {
        this.dataPrevista = dataPrevista;
    }

    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_PROPOSTA_COMERCIAL_USUARIO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @OneToMany(mappedBy="propostaComercial")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<PropostaComercialItens> getItensProposta() {
        return this.itensProposta;
    }

    public void setItensProposta(List<PropostaComercialItens> itensProposta) {
        this.itensProposta = itensProposta;
    }

    @JoinColumn(name="ID_PROPOSTA_COMERCIAL_STATUS", foreignKey=@ForeignKey(name="FK_PROPOSTA_COMERCIAL_STATUS"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PropostaComercialStatus getPropostaComercialStatus() {
        return this.propostaComercialStatus;
    }

    public void setPropostaComercialStatus(PropostaComercialStatus propostaComercialStatus) {
        this.propostaComercialStatus = propostaComercialStatus;
    }

    @Column(name="VALOR_TOTAL_ITENS", precision=15, scale=2)
    public Double getValorTotalItens() {
        return this.valorTotalItens;
    }

    public void setValorTotalItens(Double valorTotalItens) {
        this.valorTotalItens = valorTotalItens;
    }

    @Column(name="VALOR_DESCONTO", precision=15, scale=2)
    public Double getValorDesconto() {
        return this.valorDesconto;
    }

    public void setValorDesconto(Double valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    @Column(nullable=false, name="VALOR_TOTAL", precision=15, scale=2)
    public Double getValorTotal() {
        return this.valorTotal;
    }

    public void setValorTotal(Double valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Column(name="SOLUCAO")
    public String getSolucao() {
        return this.solucao;
    }

    public void setSolucao(String solucao) {
        this.solucao = solucao;
    }

    @JoinColumn(name="ID_ARQUIVAMENTO_DOC", foreignKey=@ForeignKey(name="FK_PROPOSTA_COMERCIAL_1"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ArquivamentoDoc getArquivamentoDoc() {
        return this.arquivamentoDoc;
    }

    public void setArquivamentoDoc(ArquivamentoDoc arquivamentoDoc) {
        this.arquivamentoDoc = arquivamentoDoc;
    }
}

