/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ArquivamentoDoc;
import com.touchcomp.basementor.model.vo.CampanhaVendas;
import com.touchcomp.basementor.model.vo.CotacaoVendas;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FaseComercial;
import com.touchcomp.basementor.model.vo.FunilVendas;
import com.touchcomp.basementor.model.vo.MotivoDesistencia;
import com.touchcomp.basementor.model.vo.OrigemProspeccaoPessoas;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PropostaComercial;
import com.touchcomp.basementor.model.vo.ProspPessoasModFichaTec;
import com.touchcomp.basementor.model.vo.ProspeccaoPessoasEvt;
import com.touchcomp.basementor.model.vo.ProspeccaoPessoasPessoa;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.TipoProspeccaoVenda;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="PROSPECCAO_PESSOAS")
public class ProspeccaoPessoas
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Pessoa pessoa;
    private String observacao;
    private Representante representante;
    private List<ProspeccaoPessoasPessoa> indicantes = new ArrayList<ProspeccaoPessoasPessoa>();
    private List<ProspPessoasModFichaTec> prospPessoasModFichaTec = new ArrayList<ProspPessoasModFichaTec>();
    private List<ProspeccaoPessoasEvt> eventosProspeccao = new ArrayList<ProspeccaoPessoasEvt>();
    private FaseComercial faseComercial;
    private MotivoDesistencia motivoDesistencia;
    private TipoProspeccaoVenda tipoProspeccao;
    private CampanhaVendas campanhaVendas;
    private Date dataUltEvento;
    private Date dataAberturaProspeccao;
    private Date dataEncerramentoProspeccao;
    private ArquivamentoDoc arquivoDoc;
    private OrigemProspeccaoPessoas origemProspeccaoPessoas;
    private PropostaComercial propostaComercial;
    private FunilVendas funilVendas;
    private CotacaoVendas cotacaoVendas;
    private String serialForSinc;

    @Id
    @Column(name="ID_PROSPECCAO_PESSOAS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PROSPECCAO_PESSOAS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PROSPECCAO_PESSOAS_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_PROSPECCAO_PESSOAS_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Column(name="OBSERVACAO", length=500)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @OneToMany(mappedBy="prospeccaoPessoas", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ProspeccaoPessoasPessoa> getIndicantes() {
        return this.indicantes;
    }

    public void setIndicantes(List<ProspeccaoPessoasPessoa> indicantes) {
        this.indicantes = indicantes;
    }

    @OneToMany(mappedBy="prospeccaoPessoas")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ProspPessoasModFichaTec> getProspPessoasModFichaTec() {
        return this.prospPessoasModFichaTec;
    }

    public void setProspPessoasModFichaTec(List<ProspPessoasModFichaTec> prospPessoasModFichaTec) {
        this.prospPessoasModFichaTec = prospPessoasModFichaTec;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @JoinColumn(name="ID_REPRESENTANTE", foreignKey=@ForeignKey(name="FK_PROSPECCAO_PESSOAS_REPRESENT"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Representante getRepresentante() {
        return this.representante;
    }

    public void setRepresentante(Representante representante) {
        this.representante = representante;
    }

    @OneToMany(mappedBy="prospeccaoPessoas")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ProspeccaoPessoasEvt> getEventosProspeccao() {
        return this.eventosProspeccao;
    }

    public void setEventosProspeccao(List<ProspeccaoPessoasEvt> eventosProspeccao) {
        this.eventosProspeccao = eventosProspeccao;
    }

    @JoinColumn(name="ID_FASE_COMERCIAL", foreignKey=@ForeignKey(name="FK_PROSPECCAO_PESSOAS_FA_COM"))
    @ManyToOne(fetch=FetchType.LAZY)
    public FaseComercial getFaseComercial() {
        return this.faseComercial;
    }

    public void setFaseComercial(FaseComercial faseComercial) {
        this.faseComercial = faseComercial;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getObservacao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ULT_EVENTO")
    public Date getDataUltEvento() {
        return this.dataUltEvento;
    }

    public void setDataUltEvento(Date dataUltEvento) {
        this.dataUltEvento = dataUltEvento;
    }

    @JoinColumn(name="ID_ARQUIVO_DOC", foreignKey=@ForeignKey(name="FK_PROSPECCAO_PESSOAS_ARQ_DOC"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ArquivamentoDoc getArquivoDoc() {
        return this.arquivoDoc;
    }

    public void setArquivoDoc(ArquivamentoDoc arquivoDoc) {
        this.arquivoDoc = arquivoDoc;
    }

    @JoinColumn(name="ID_ORIGEM_PROSPECCAO_PESSOAS", foreignKey=@ForeignKey(name="FK_PROSPECCAO_PESSOAS_ORIGEM"))
    @ManyToOne(fetch=FetchType.LAZY)
    public OrigemProspeccaoPessoas getOrigemProspeccaoPessoas() {
        return this.origemProspeccaoPessoas;
    }

    public void setOrigemProspeccaoPessoas(OrigemProspeccaoPessoas origemProspeccaoPessoas) {
        this.origemProspeccaoPessoas = origemProspeccaoPessoas;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MOTIVO_DESISTENCIA", foreignKey=@ForeignKey(name="FK_PROSPECCAO_PESSOAS_MOT_DES"))
    public MotivoDesistencia getMotivoDesistencia() {
        return this.motivoDesistencia;
    }

    public void setMotivoDesistencia(MotivoDesistencia motivoDesistencia) {
        this.motivoDesistencia = motivoDesistencia;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_PROSPECCAO", foreignKey=@ForeignKey(name="FK_PROSPECCAO_PESSOAS_TP_PROSP"))
    public TipoProspeccaoVenda getTipoProspeccao() {
        return this.tipoProspeccao;
    }

    public void setTipoProspeccao(TipoProspeccaoVenda tipoProspeccao) {
        this.tipoProspeccao = tipoProspeccao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CAMPANHA_VENDAS", foreignKey=@ForeignKey(name="FK_PROSPECCAO_PESSOAS_CAMP_VEND"))
    public CampanhaVendas getCampanhaVendas() {
        return this.campanhaVendas;
    }

    public void setCampanhaVendas(CampanhaVendas campanhaVendas) {
        this.campanhaVendas = campanhaVendas;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ABERTURA_PROSPECCAO")
    public Date getDataAberturaProspeccao() {
        return this.dataAberturaProspeccao;
    }

    public void setDataAberturaProspeccao(Date dataAberturaProspeccao) {
        this.dataAberturaProspeccao = dataAberturaProspeccao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ENCERRAMENTO_PROSPECCAO")
    public Date getDataEncerramentoProspeccao() {
        return this.dataEncerramentoProspeccao;
    }

    public void setDataEncerramentoProspeccao(Date dataEncerramentoProspeccao) {
        this.dataEncerramentoProspeccao = dataEncerramentoProspeccao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PROPOSTA_COMERCIAL")
    public PropostaComercial getPropostaComercial() {
        return this.propostaComercial;
    }

    public void setPropostaComercial(PropostaComercial propostaComercial) {
        this.propostaComercial = propostaComercial;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FUNIL_VENDAS")
    public FunilVendas getFunilVendas() {
        return this.funilVendas;
    }

    public void setFunilVendas(FunilVendas funilVendas) {
        this.funilVendas = funilVendas;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COTACAO_VENDAS")
    public CotacaoVendas getCotacaoVendas() {
        return this.cotacaoVendas;
    }

    public void setCotacaoVendas(CotacaoVendas cotacaoVendas) {
        this.cotacaoVendas = cotacaoVendas;
    }

    @Column(name="SERIAL_FOR_SINC", length=100)
    public String getSerialForSinc() {
        return this.serialForSinc;
    }

    public void setSerialForSinc(String serialForSinc) {
        this.serialForSinc = serialForSinc;
    }
}

