/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCustoItemQuadroVagas;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FuncaoItemQuadroVagas;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="QUADRO_VAGAS")
public class QuadroVagas
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private String descricao;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private List<FuncaoItemQuadroVagas> funcaoItem = new ArrayList<FuncaoItemQuadroVagas>();
    private List<CentroCustoItemQuadroVagas> centroCustoItem = new ArrayList<CentroCustoItemQuadroVagas>();
    private Long numeroVagas = 0L;

    @Id
    @Column(name="ID_QUADRO_VAGA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_QUADRO_VAGAS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_QUADRO_VAGAS_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="quadroVagas")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<FuncaoItemQuadroVagas> getFuncaoItem() {
        return this.funcaoItem;
    }

    public void setFuncaoItem(List<FuncaoItemQuadroVagas> funcaoItem) {
        this.funcaoItem = funcaoItem;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="quadroVagas")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<CentroCustoItemQuadroVagas> getCentroCustoItem() {
        return this.centroCustoItem;
    }

    public void setCentroCustoItem(List<CentroCustoItemQuadroVagas> centroCustoItem) {
        this.centroCustoItem = centroCustoItem;
    }

    @Column(name="NUMERO_VAGAS")
    public Long getNumeroVagas() {
        return this.numeroVagas;
    }

    public void setNumeroVagas(Long numeroVagas) {
        this.numeroVagas = numeroVagas;
    }

    @Column(name="DESCRICAO", length=200)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getNumeroVagas()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

