/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Pesquisa;
import com.touchcomp.basementor.model.vo.QuestaoPesquisaVlrPadrao;
import com.touchcomp.basementor.model.vo.TipoItemModeloFichaTecnica;
import com.touchcomp.basementor.model.vo.TipoPerguntaPesquisa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="QUESTAO_PESQUISA")
public class QuestaoPesquisa
implements InterfaceVO {
    private Long identificador;
    private String pergunta;
    private Double notaMaxima = 0.0;
    private Double notaMinima = 0.0;
    private Pesquisa pesquisa;
    private List<QuestaoPesquisaVlrPadrao> valoresPadroes = new LinkedList<QuestaoPesquisaVlrPadrao>();
    private TipoItemModeloFichaTecnica tipoItem;
    private TipoPerguntaPesquisa tipoPergunta;

    @Id
    @Column(name="ID_QUESTAO_PESQUISA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_QUESTAO_PESQUISA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="PERGUNTA", length=500)
    public String getPergunta() {
        return this.pergunta;
    }

    public void setPergunta(String pergunta) {
        this.pergunta = pergunta;
    }

    @Column(nullable=false, name="NOTA_MAXIMA", precision=15, scale=2)
    public Double getNotaMaxima() {
        return this.notaMaxima;
    }

    public void setNotaMaxima(Double notaMaxima) {
        this.notaMaxima = notaMaxima;
    }

    @Column(nullable=false, name="NOTA_MINIMA", precision=15, scale=2)
    public Double getNotaMinima() {
        return this.notaMinima;
    }

    public void setNotaMinima(Double notaMinima) {
        this.notaMinima = notaMinima;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getPergunta()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @JoinColumn(name="ID_PESQUISA", foreignKey=@ForeignKey(name="FK_QUESTAO_PESQUISA_PESQUISA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Pesquisa getPesquisa() {
        return this.pesquisa;
    }

    public void setPesquisa(Pesquisa pesquisa) {
        this.pesquisa = pesquisa;
    }

    @OneToMany(mappedBy="questaoPesquisa")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<QuestaoPesquisaVlrPadrao> getValoresPadroes() {
        return this.valoresPadroes;
    }

    public void setValoresPadroes(List<QuestaoPesquisaVlrPadrao> valoresPadroes) {
        this.valoresPadroes = valoresPadroes;
    }

    @JoinColumn(name="ID_TIPO_ITEM", foreignKey=@ForeignKey(name="FK_QUESTAO_PESQUISA_TIPO_ITEM"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TipoItemModeloFichaTecnica getTipoItem() {
        return this.tipoItem;
    }

    public void setTipoItem(TipoItemModeloFichaTecnica tipoItem) {
        this.tipoItem = tipoItem;
    }

    @JoinColumn(name="ID_TIPO_PERGUNTA", foreignKey=@ForeignKey(name="FK_QUESTAO_PESQUISA_TIPO_PERGUN"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TipoPerguntaPesquisa getTipoPergunta() {
        return this.tipoPergunta;
    }

    public void setTipoPergunta(TipoPerguntaPesquisa tipoPergunta) {
        this.tipoPergunta = tipoPergunta;
    }
}

