/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.manifestocteeletronico.EnumConstManifestoCteTipoValePedagio;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CartaoValePedagio;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="RECARGA_CARTAO_VALE_PED")
public class RecargaCartaoValePed
implements InterfaceVO {
    private Long identificador;
    private CartaoValePedagio cartaoValePedagio;
    private Double valorRecarga = 0.0;
    private Timestamp dataAtualizacao;
    private Date dataCadastro;
    private Date dataRecarga;
    private Empresa empresa;
    private String numeroRecCompra;
    private Pessoa responsavelPgVale;
    private Short tipoValePedagio = EnumConstManifestoCteTipoValePedagio.TAG.getEnumId();

    @Id
    @Column(name="ID_RECARGA_CARTAO_VALE_PED")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_RECARGA_CARTAO_VALE_PED")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CARTAO_VALE_PED", foreignKey=@ForeignKey(name="FK_RECARGA_CARTAO_VALE_PED_CART"))
    public CartaoValePedagio getCartaoValePedagio() {
        return this.cartaoValePedagio;
    }

    public void setCartaoValePedagio(CartaoValePedagio cartaoValePedagio) {
        this.cartaoValePedagio = cartaoValePedagio;
    }

    @Column(nullable=false, name="VALOR_RECARGA", precision=15, scale=2)
    public Double getValorRecarga() {
        return this.valorRecarga;
    }

    public void setValorRecarga(Double valorRecarga) {
        this.valorRecarga = valorRecarga;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_RECARGA")
    public Date getDataRecarga() {
        return this.dataRecarga;
    }

    public void setDataRecarga(Date dataRecarga) {
        this.dataRecarga = dataRecarga;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_RECARGA_CARTAO_VALE_PED_EMPR"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getCartaoValePedagio()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="NUMERO_REC_COMPRA", length=20)
    public String getNumeroRecCompra() {
        return this.numeroRecCompra;
    }

    public void setNumeroRecCompra(String numeroRecCompra) {
        this.numeroRecCompra = numeroRecCompra;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_RESPONSAVEL_PG_VALE", foreignKey=@ForeignKey(name="FK_RECARGA_CARTAO_VALE_PED_PESS"))
    public Pessoa getResponsavelPgVale() {
        return this.responsavelPgVale;
    }

    public void setResponsavelPgVale(Pessoa responsavelPgVale) {
        this.responsavelPgVale = responsavelPgVale;
    }

    @Column(name="TIPO_VALE_PEDAGIO")
    public Short getTipoValePedagio() {
        return this.tipoValePedagio;
    }

    public void setTipoValePedagio(Short tipoValePedagio) {
        this.tipoValePedagio = tipoValePedagio;
    }
}

