/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.constants.enums.receitaagronomica.EnumConstProvedorRecAgro;
import com.touchcomp.basementor.constants.enums.receitaagronomica.EnumConstStatusReceitaAgro;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemReceitaAgronomica;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.TalhaoPropriedade;
import com.touchcomp.basementor.model.vo.TecnicoAgricola;
import com.touchcomp.basementor.model.vo.TecnicoAgricolaART;
import com.touchcomp.basementor.model.vo.TecnicoAgricolaCREA;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="RECEITA_AGRONOMICA")
public class ReceitaAgronomica
implements InterfaceVO {
    private Long identificador;
    private TecnicoAgricola tecnicoAgricola;
    private NotaFiscalPropria notaPropria;
    private List<ItemReceitaAgronomica> itemReceitaAgronomica = new ArrayList<ItemReceitaAgronomica>();
    private UnidadeFatCliente unidadeFatCliente;
    private Short status = EnumConstStatusReceitaAgro.ABERTA.getValue();
    private String codSincronizacao;
    private Short codProvServicoRec = EnumConstProvedorRecAgro.SEM_VINCULO_SERVICO.getValue();
    private Empresa empresa;
    private Date dataCadastro;
    private Date dataEmissao;
    private Timestamp dataAtualizacao;
    private String motivoCancelamento;
    private Long nrReceita;
    private String nrARTVinculada;
    private TalhaoPropriedade talhaoPropriedade;
    private TecnicoAgricolaART tecnicoAgricART;
    private TecnicoAgricolaCREA tecnicoAgricCREA;
    private String observacoesEmissao;
    private String observacoes;
    private Pedido pedido;

    @Id
    @Column(nullable=false, name="ID_RECEITA_AGRONOMICA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_RECEITA_AGRONOMICA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @JoinColumn(name="ID_TECNICO_AGRICOLA", foreignKey=@ForeignKey(name="FK_RECEITA_AGRONOMICA_TEC_AGRIC"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TecnicoAgricola getTecnicoAgricola() {
        return this.tecnicoAgricola;
    }

    public void setTecnicoAgricola(TecnicoAgricola tecnicoAgricola) {
        this.tecnicoAgricola = tecnicoAgricola;
    }

    @JoinColumn(name="ID_NOTA_PROPRIA", foreignKey=@ForeignKey(name="FK_RECEITA_AGRONOMICA_NOTA_PROP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public NotaFiscalPropria getNotaPropria() {
        return this.notaPropria;
    }

    public void setNotaPropria(NotaFiscalPropria notaPropria) {
        this.notaPropria = notaPropria;
    }

    @OneToMany(mappedBy="receitaAgronomica", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ItemReceitaAgronomica> getItemReceitaAgronomica() {
        return this.itemReceitaAgronomica;
    }

    public void setItemReceitaAgronomica(List itemReceitaAgronomica) {
        this.itemReceitaAgronomica = itemReceitaAgronomica;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_RECEITA_AGRONOMICA_EMRPESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNIDADE_FAT_CLIENTE", foreignKey=@ForeignKey(name="FK_RECEITA_AGRONOMICA_UN_FAT_CL"))
    public UnidadeFatCliente getUnidadeFatCliente() {
        return this.unidadeFatCliente;
    }

    public void setUnidadeFatCliente(UnidadeFatCliente unidadeFatCliente) {
        this.unidadeFatCliente = unidadeFatCliente;
    }

    @Column(name="STATUS")
    public Short getStatus() {
        return this.status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    @Column(name="COD_SINCRONIZACAO", length=10)
    public String getCodSincronizacao() {
        return this.codSincronizacao;
    }

    public void setCodSincronizacao(String codSincronizacao) {
        this.codSincronizacao = codSincronizacao;
    }

    @Column(name="COD_PROV_SERVICO_REC")
    public Short getCodProvServicoRec() {
        return this.codProvServicoRec;
    }

    public void setCodProvServicoRec(Short codProvServicoRec) {
        this.codProvServicoRec = codProvServicoRec;
    }

    @Column(name="MOTIVO_CANCELAMENTO", length=1000)
    public String getMotivoCancelamento() {
        return this.motivoCancelamento;
    }

    public void setMotivoCancelamento(String motivoCancelamento) {
        this.motivoCancelamento = motivoCancelamento;
    }

    @Ignore
    @Column(name="NR_RECEITA")
    public Long getNrReceita() {
        return this.nrReceita;
    }

    public void setNrReceita(Long nrReceita) {
        this.nrReceita = nrReceita;
    }

    @Column(name="NR_ART_VINCULADA", length=25)
    public String getNrARTVinculada() {
        return this.nrARTVinculada;
    }

    public void setNrARTVinculada(String nrARTVinculada) {
        this.nrARTVinculada = nrARTVinculada;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_EMISSAO")
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @ManyToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TALHAO_PROPRIEDADE", foreignKey=@ForeignKey(name="FK_RECEITA_AGRO_TALHAO_PROP"))
    public TalhaoPropriedade getTalhaoPropriedade() {
        return this.talhaoPropriedade;
    }

    public void setTalhaoPropriedade(TalhaoPropriedade talhaoPropriedade) {
        this.talhaoPropriedade = talhaoPropriedade;
    }

    @ManyToOne
    @JoinColumn(name="ID_TECNICO_AGRIC_ART", foreignKey=@ForeignKey(name="FK_RECEITA_AGRO_TEC_AGR_ART"))
    public TecnicoAgricolaART getTecnicoAgricART() {
        return this.tecnicoAgricART;
    }

    public void setTecnicoAgricART(TecnicoAgricolaART tecnicoAgricART) {
        this.tecnicoAgricART = tecnicoAgricART;
    }

    @ManyToOne
    @JoinColumn(name="ID_TECNICO_AGRIC_CREA", foreignKey=@ForeignKey(name="FK_RECEITA_AGRO_TEC_AGR_CREA"))
    public TecnicoAgricolaCREA getTecnicoAgricCREA() {
        return this.tecnicoAgricCREA;
    }

    public void setTecnicoAgricCREA(TecnicoAgricolaCREA tecnicoAgricCREA) {
        this.tecnicoAgricCREA = tecnicoAgricCREA;
    }

    @Column(name="observacoes_emissao")
    public String getObservacoesEmissao() {
        return this.observacoesEmissao;
    }

    public void setObservacoesEmissao(String observacoesEmissao) {
        this.observacoesEmissao = observacoesEmissao;
    }

    @Column(name="observacoes")
    public String getObservacoes() {
        return this.observacoes;
    }

    public void setObservacoes(String observacoes) {
        this.observacoes = observacoes;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PEDIDO", foreignKey=@ForeignKey(name="FK_RECEITA_AGRONOMICA_PEDIDO"))
    public Pedido getPedido() {
        return this.pedido;
    }

    public void setPedido(Pedido pedido) {
        this.pedido = pedido;
    }
}

