/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.recepcaomercadorias.EnumConstTipoNotaFiscalRecepcao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemRecepcaoMercadorias;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.ObsCriticasRecepcaoMercadorias;
import com.touchcomp.basementor.model.vo.OrdemCompra;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="RECEPCAO_MERCADORIAS")
public class RecepcaoMercadorias
implements InterfaceVO {
    private Long identificador;
    private Date dataEntradaSaida;
    private List<OrdemCompra> ordemCompra;
    private List<ItemRecepcaoMercadorias> itemRecepcao = new ArrayList<ItemRecepcaoMercadorias>();
    private Usuario usuario;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Short notaImpXml = 0;
    private NotaFiscalTerceiros notaFiscalTerceiros;
    private List<ObsCriticasRecepcaoMercadorias> obsCriticas = new ArrayList<ObsCriticasRecepcaoMercadorias>();
    private Short tipoNotaFiscal;
    private NotaFiscalPropria notaFiscalPropria;

    public RecepcaoMercadorias() {
        this.ordemCompra = new ArrayList<OrdemCompra>();
        this.tipoNotaFiscal = EnumConstTipoNotaFiscalRecepcao.NOTA_TERCEIROS.getValue();
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_RECEPCAO_MERCADORIAS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_RECEPCAO_MERCADORIAS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_ENTRADA")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEntradaSaida() {
        return this.dataEntradaSaida;
    }

    public void setDataEntradaSaida(Date dataEntradaSaida) {
        this.dataEntradaSaida = dataEntradaSaida;
    }

    @OneToMany(fetch=FetchType.LAZY, targetEntity=OrdemCompra.class, cascade={CascadeType.MERGE, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinTable(name="rec_mercadorias_ordem_compra", joinColumns={@JoinColumn(name="id_rec_mercadorias")}, inverseJoinColumns={@JoinColumn(name="id_ordem_compra")})
    public List<OrdemCompra> getOrdemCompra() {
        return this.ordemCompra;
    }

    public void setOrdemCompra(List<OrdemCompra> ordemCompra) {
        this.ordemCompra = ordemCompra;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="recepcaoMercadoria", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ItemRecepcaoMercadorias> getItemRecepcao() {
        return this.itemRecepcao;
    }

    public void setItemRecepcao(List<ItemRecepcaoMercadorias> itemRecepcao) {
        this.itemRecepcao = itemRecepcao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_RECEPCAO_MERCADORIAS_USUARIO"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_RECEPCAO_MERCADORIAS_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NOTA_TERCEIROS", foreignKey=@ForeignKey(name="FK_RECEPCAO_MERCADORIAS_NF_TERC"))
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public NotaFiscalTerceiros getNotaFiscalTerceiros() {
        return this.notaFiscalTerceiros;
    }

    public void setNotaFiscalTerceiros(NotaFiscalTerceiros notaFiscalTerceiros) {
        this.notaFiscalTerceiros = notaFiscalTerceiros;
    }

    @Column(name="NOTA_IMP_XML")
    public Short getNotaImpXml() {
        return this.notaImpXml;
    }

    public void setNotaImpXml(Short notaImpXml) {
        this.notaImpXml = notaImpXml;
    }

    @OneToMany(mappedBy="recepcaoMercadorias", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ObsCriticasRecepcaoMercadorias> getObsCriticas() {
        return this.obsCriticas;
    }

    public void setObsCriticas(List<ObsCriticasRecepcaoMercadorias> obsCriticas) {
        this.obsCriticas = obsCriticas;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="TIPO_NOTA_FISCAL")
    public Short getTipoNotaFiscal() {
        return this.tipoNotaFiscal;
    }

    public void setTipoNotaFiscal(Short tipoNotaFiscal) {
        this.tipoNotaFiscal = tipoNotaFiscal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NOTA_PROPRIA", foreignKey=@ForeignKey(name="FK_RECEPCAO_MERC_NOTA_PROPRIA"))
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public NotaFiscalPropria getNotaFiscalPropria() {
        return this.notaFiscalPropria;
    }

    public void setNotaFiscalPropria(NotaFiscalPropria notaFiscalPropria) {
        this.notaFiscalPropria = notaFiscalPropria;
    }
}

