/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.BaseInssEscalonada;
import com.touchcomp.basementor.model.vo.CadastroRecisao;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.EmissaoAvisoTrabalhado;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocCumprimentoAviso;
import com.touchcomp.basementor.model.vo.EsocIndicativoPensao;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.IntegracaoRecisaoContIntermitente;
import com.touchcomp.basementor.model.vo.ItemMovimentoRescisao;
import com.touchcomp.basementor.model.vo.ItemOutrosTitulosFolha;
import com.touchcomp.basementor.model.vo.MediaRecisaoColaborador;
import com.touchcomp.basementor.model.vo.RecisaoComplementar;
import com.touchcomp.basementor.model.vo.Rubricas2299;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="RECISAO")
public class Recisao
implements InterfaceVO,
InterfaceVOEsocial {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private Integer nrRecibo = 0;
    private Colaborador colaborador;
    private Short avisoIndenizado = 0;
    private CadastroRecisao cadastroRecisao;
    private Date dataDemissao;
    private Date dataPagamento;
    private Date dataInicioAviso;
    private Date dataFimAviso;
    private List<MediaRecisaoColaborador> mediaRecisao;
    private List<MediaRecisaoColaborador> mediasFeriasVencidas;
    private List<ItemMovimentoRescisao> itemRescisao;
    private Double maiorSalario = 0.0;
    private Double nrAvosFerias = 0.0;
    private Double nrAvosDec = 0.0;
    private Double bcInss = 0.0;
    private Double bcIrrf = 0.0;
    private Double bcFgts = 0.0;
    private Double aliquotaInss = 0.0;
    private Double aliquotaFgts = 0.0;
    private Double aliquotaIrrf = 0.0;
    private Double vlrInss = 0.0;
    private Double vrlIrrf = 0.0;
    private Double vrlFgts = 0.0;
    private Short nrDependentes = 0;
    private Double vlrLiquido = 0.0;
    private Double vlrProventos = 0.0;
    private Double vlrDescontos = 0.0;
    private Double nrFaltas = 0.0;
    private Double nrDescontoDSR = 0.0;
    private Double nrDiasTrabalhados = 0.0;
    private Double nrDiasFolgas = 0.0;
    private Double nrDiasferiados = 0.0;
    private Double diasUteis = 0.0;
    private Double bcIrrf13 = 0.0;
    private Double aliquotaIrrf13 = 0.0;
    private Double vlrIrrf13 = 0.0;
    private Double bcInss13 = 0.0;
    private Double aliquotaInss13 = 0.0;
    private Double vlrInss13 = 0.0;
    private Double totalMediaFerias = 0.0;
    private Double totalMedia13 = 0.0;
    private Double totalMediaAviso = 0.0;
    private Double totalMediaFeriasVencidas = 0.0;
    private String reposicaoVaga;
    private String tipoContrato;
    private Double ultimaRemuneracao = 0.0;
    private Date dataAfastamento;
    private Double nrQuota = 0.0;
    private Double faltasDescontoFerias = 0.0;
    private Short recisaoComplementar = 0;
    private Date dataInicialFeriasVencidas;
    private Date dataFinalFeriasVencidas;
    private Date ultimaDataFerias;
    private Double bcGrrfSalario = 0.0;
    private Double aliqGrrfSalario = 0.0;
    private Double vlrGrrfsalario = 0.0;
    private Double bcGrrfIndenizado = 0.0;
    private Double aliqGrrfIndenizado = 0.0;
    private Double vlrGrrfIndenizado = 0.0;
    private Double vlrSaldoFgts = 0.0;
    private Double vlrMultaQuarentaPorCento = 0.0;
    private Double vlrMultaDezPorCento = 0.0;
    private Double vlrMultaVintePorCentro = 0.0;
    private Double vlrTotalGrrf = 0.0;
    private Double vlrTotalBaseMes = 0.0;
    private Double diasDireitoFeriasVencidas = 0.0;
    private Double diasDireitoFeriasProporcionais = 0.0;
    private Double vlrFgtsMesAnterior = 0.0;
    private Double diasAviso = 0.0;
    private Short jrnSemanalIntegral = 0;
    private Short sabadoCompensado = 0;
    private Double bcInssSalario = 0.0;
    private Double bcInssFerias = 0.0;
    private Double vlrInssSalario = 0.0;
    private Double vlrInssFerias = 0.0;
    private Double aliqInssSalario = 0.0;
    private Double aliqInssFerias = 0.0;
    private Double bcIrrfFerias = 0.0;
    private Double vlrIrrfFerias = 0.0;
    private Double aliqIrrfFerias = 0.0;
    private Short alterarImpostoManual = 0;
    private Double vlrIrrfFeriasGozadas = 0.0;
    private Double diasUteisDRS = 0.0;
    private Double diasFolgasFeriadosDSR = 0.0;
    private Short informarDiasDSR = 0;
    private Date dataVencimentoGrrf;
    private Double faltasFeriasVencidas = 0.0;
    private Short complementarComDissidio = 0;
    private Double bcIrrfAnterior = 0.0;
    private Double vlrIrrfAnterior = 0.0;
    private Double avosFeriasIndenizadas = 0.0;
    private Double avosDecIndenizados = 0.0;
    private Short informarAvosManualmente = 0;
    private Date inicioContagemDecIndenizado;
    private Date inicioContagemFeriasInd;
    private Short recisaoPorAcordo = 0;
    private List<EsocPreEvento> preEventosEsocial = new ArrayList<EsocPreEvento>();
    private EmissaoAvisoTrabalhado emissaoAviso;
    private Short indicativoPagamentoAviso = 0;
    private EsocIndicativoPensao indicativoPensao;
    private Double valorPensao = 0.0;
    private Double percPensao = 0.0;
    private String numeroCertidaoObito;
    private String numeroProcTrabalhista;
    private EsocCumprimentoAviso cumprimentoAviso;
    private String observacoes;
    private RecisaoComplementar recisaoComplementarAc;
    private Short indenizarAvisoTrabalhado = 1;
    private List<Rubricas2299> rubricas = new ArrayList<Rubricas2299>();
    private List<IntegracaoRecisaoContIntermitente> convocacao;
    private Double diasContratoIntermitente = 0.0;
    private Double avosDecMaternidade = 0.0;
    private List<BaseInssEscalonada> baseInssEscalonada;
    private CentroCusto centroCusto;
    private Double bcIrrfPlr = 0.0;
    private Double numeroFaltasHoras = 0.0;
    private ItemOutrosTitulosFolha outrosTitulosFolha;

    public Recisao() {
        this.mediaRecisao = new ArrayList<MediaRecisaoColaborador>();
        this.mediasFeriasVencidas = new ArrayList<MediaRecisaoColaborador>();
        this.itemRescisao = new ArrayList<ItemMovimentoRescisao>();
        this.convocacao = new ArrayList<IntegracaoRecisaoContIntermitente>();
        this.baseInssEscalonada = new ArrayList<BaseInssEscalonada>();
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_RECISAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_RECISAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_RECISAO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Generated(value=GenerationTime.INSERT)
    @Column(name="NR_RECISO_RECISAO")
    public Integer getNrRecibo() {
        return this.nrRecibo;
    }

    public void setNrRecibo(Integer nrRecibo) {
        this.nrRecibo = nrRecibo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COLABORADOR", foreignKey=@ForeignKey(name="FK_RECISAO_COLABORADOR"))
    public Colaborador getColaborador() {
        return this.colaborador;
    }

    public void setColaborador(Colaborador colaborador) {
        this.colaborador = colaborador;
    }

    @Column(name="AVISO_PREVIO_INDENIZADO")
    public Short getAvisoIndenizado() {
        return this.avisoIndenizado;
    }

    public void setAvisoIndenizado(Short avisoIndenizado) {
        this.avisoIndenizado = avisoIndenizado;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_DEMISSAO")
    public Date getDataDemissao() {
        return this.dataDemissao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CADASTRO_RECISAO", foreignKey=@ForeignKey(name="FK_RECISAO_CADASTRO_RECISAO"))
    public CadastroRecisao getCadastroRecisao() {
        return this.cadastroRecisao;
    }

    public void setCadastroRecisao(CadastroRecisao cadastroRecisao) {
        this.cadastroRecisao = cadastroRecisao;
    }

    public void setDataDemissao(Date dataDemissao) {
        this.dataDemissao = dataDemissao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_PAGAMENTO")
    public Date getDataPagamento() {
        return this.dataPagamento;
    }

    public void setDataPagamento(Date dataPagamento) {
        this.dataPagamento = dataPagamento;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_INICIO_AVISO")
    public Date getDataInicioAviso() {
        return this.dataInicioAviso;
    }

    public void setDataInicioAviso(Date dataInicioAviso) {
        this.dataInicioAviso = dataInicioAviso;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FINAL_AVISO")
    public Date getDataFimAviso() {
        return this.dataFimAviso;
    }

    public void setDataFimAviso(Date dataFimAviso) {
        this.dataFimAviso = dataFimAviso;
    }

    @OneToMany(mappedBy="recisao", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<MediaRecisaoColaborador> getMediaRecisao() {
        return this.mediaRecisao;
    }

    public void setMediaRecisao(List<MediaRecisaoColaborador> mediaDecAviso) {
        this.mediaRecisao = mediaDecAviso;
    }

    @Column(name="MAIOR_SALARIO", precision=15, scale=4)
    public Double getMaiorSalario() {
        return this.maiorSalario;
    }

    public void setMaiorSalario(Double maiorSalario) {
        this.maiorSalario = maiorSalario;
    }

    @Column(name="NR_AVOS_FERIAS", precision=15, scale=4)
    public Double getNrAvosFerias() {
        return this.nrAvosFerias;
    }

    public void setNrAvosFerias(Double nrAvos) {
        this.nrAvosFerias = nrAvos;
    }

    @Column(name="NR_AVOS_DEC", precision=15, scale=4)
    public Double getNrAvosDec() {
        return this.nrAvosDec;
    }

    public void setNrAvosDec(Double nrAvosDec) {
        this.nrAvosDec = nrAvosDec;
    }

    @Column(name="BC_INSS", precision=15, scale=4)
    public Double getBcInss() {
        this.bcInss = this.bcInss == null || this.bcInss < 0.0 ? 0.0 : this.bcInss;
        return this.bcInss;
    }

    public void setBcInss(Double bcInss) {
        this.bcInss = bcInss = Double.valueOf(bcInss == null || bcInss < 0.0 ? 0.0 : bcInss);
    }

    @Column(name="BC_IRRF", precision=15, scale=4)
    public Double getBcIrrf() {
        this.bcIrrf = this.bcIrrf == null || this.bcIrrf < 0.0 ? 0.0 : this.bcIrrf;
        return this.bcIrrf;
    }

    public void setBcIrrf(Double bcIrrf) {
        this.bcIrrf = bcIrrf = Double.valueOf(bcIrrf == null || bcIrrf < 0.0 ? 0.0 : bcIrrf);
    }

    @Column(name="BC_FGTS", precision=15, scale=4)
    public Double getBcFgts() {
        return this.bcFgts;
    }

    public void setBcFgts(Double bcFgts) {
        this.bcFgts = bcFgts;
    }

    @Column(name="ALIQUOTA_INSS", precision=15, scale=4)
    public Double getAliquotaInss() {
        return this.aliquotaInss;
    }

    public void setAliquotaInss(Double aliquotaInss) {
        this.aliquotaInss = aliquotaInss;
    }

    @Column(name="ALIQUOTA_FGTS", precision=15, scale=4)
    public Double getAliquotaFgts() {
        return this.aliquotaFgts;
    }

    public void setAliquotaFgts(Double aliquotaFgts) {
        this.aliquotaFgts = aliquotaFgts;
    }

    @Column(name="ALIQUOTA_IRRF", precision=15, scale=4)
    public Double getAliquotaIrrf() {
        return this.aliquotaIrrf;
    }

    public void setAliquotaIrrf(Double aliquotaIrrf) {
        this.aliquotaIrrf = aliquotaIrrf;
    }

    @Column(nullable=false, name="VLR_INSS", precision=15, scale=4)
    public Double getVlrInss() {
        this.vlrInss = this.vlrInss == null || this.vlrInss < 0.0 ? 0.0 : this.vlrInss;
        return this.vlrInss;
    }

    public void setVlrInss(Double vlrInss) {
        this.vlrInss = vlrInss = Double.valueOf(vlrInss == null || vlrInss < 0.0 ? 0.0 : vlrInss);
    }

    @Column(name="VLR_IRRF", precision=15, scale=4)
    public Double getVrlIrrf() {
        this.vrlIrrf = this.vrlIrrf == null || this.vrlIrrf < 0.0 ? 0.0 : this.vrlIrrf;
        return this.vrlIrrf;
    }

    public void setVrlIrrf(Double vrlIrrf) {
        this.vrlIrrf = vrlIrrf;
    }

    @Column(name="VLR_FGTS", precision=15, scale=4)
    public Double getVrlFgts() {
        return this.vrlFgts;
    }

    public void setVrlFgts(Double vrlFgts) {
        this.vrlFgts = vrlFgts;
    }

    @Column(name="NR_DEPENDENTE")
    public Short getNrDependentes() {
        return this.nrDependentes;
    }

    public void setNrDependentes(Short nrDependentes) {
        this.nrDependentes = nrDependentes;
    }

    @Column(name="VLR_LIQUIDO_RECISAO", precision=15, scale=4)
    public Double getVlrLiquido() {
        return this.vlrLiquido;
    }

    public void setVlrLiquido(Double vlrLiquido) {
        this.vlrLiquido = vlrLiquido;
    }

    @Column(name="VLR_PROVENTOS", precision=15, scale=4)
    public Double getVlrProventos() {
        return this.vlrProventos;
    }

    public void setVlrProventos(Double vlrProventos) {
        this.vlrProventos = vlrProventos;
    }

    @Column(name="VLR_DESCONTOS", precision=15, scale=4)
    public Double getVlrDescontos() {
        return this.vlrDescontos;
    }

    public void setVlrDescontos(Double vlrDescontos) {
        this.vlrDescontos = vlrDescontos;
    }

    @Column(name="NR_FALTAS", precision=15, scale=4)
    public Double getNrFaltas() {
        return this.nrFaltas;
    }

    public void setNrFaltas(Double nrFaltas) {
        this.nrFaltas = nrFaltas;
    }

    @Column(name="NR_DESCONTO_DSR", precision=15, scale=4)
    public Double getNrDescontoDSR() {
        return this.nrDescontoDSR;
    }

    public void setNrDescontoDSR(Double nrDescontoDSR) {
        this.nrDescontoDSR = nrDescontoDSR;
    }

    @Column(name="NR_DIAS_TRABALHADOS", precision=15, scale=4)
    public Double getNrDiasTrabalhados() {
        return this.nrDiasTrabalhados;
    }

    public void setNrDiasTrabalhados(Double nrDiasTrabalhados) {
        this.nrDiasTrabalhados = nrDiasTrabalhados;
    }

    @Column(name="NR_DIAS_FOLGAS", precision=15, scale=4)
    public Double getNrDiasFolgas() {
        return this.nrDiasFolgas;
    }

    public void setNrDiasFolgas(Double nrDiasFolgas) {
        this.nrDiasFolgas = nrDiasFolgas;
    }

    @Column(nullable=false, name="NR_DIAS_FERIADOS", precision=15, scale=4)
    public Double getNrDiasferiados() {
        return this.nrDiasferiados;
    }

    public void setNrDiasferiados(Double nrDiasferiados) {
        this.nrDiasferiados = nrDiasferiados;
    }

    @Column(name="NR_DIAS_UTEIS", precision=15, scale=4)
    public Double getDiasUteis() {
        return this.diasUteis;
    }

    public void setDiasUteis(Double diasUteis) {
        this.diasUteis = diasUteis;
    }

    @Column(name="BC_IRRF_DEC", precision=15, scale=4)
    public Double getBcIrrf13() {
        return this.bcIrrf13;
    }

    public void setBcIrrf13(Double bcIrrf13) {
        this.bcIrrf13 = bcIrrf13 = Double.valueOf(bcIrrf13 == null ? 0.0 : bcIrrf13);
    }

    @Column(name="ALI_IRRF_DEC", precision=15, scale=4)
    public Double getAliquotaIrrf13() {
        return this.aliquotaIrrf13;
    }

    public void setAliquotaIrrf13(Double aliquotaIrrf13) {
        this.aliquotaIrrf13 = aliquotaIrrf13 = Double.valueOf(aliquotaIrrf13 == null ? 0.0 : aliquotaIrrf13);
    }

    @Column(name="VLR_IRRF_DEC", precision=15, scale=4)
    public Double getVlrIrrf13() {
        this.vlrIrrf13 = this.vlrIrrf13 == null ? 0.0 : this.vlrIrrf13;
        return this.vlrIrrf13;
    }

    public void setVlrIrrf13(Double vlrIrrf13) {
        this.vlrIrrf13 = vlrIrrf13 = Double.valueOf(vlrIrrf13 == null ? 0.0 : vlrIrrf13);
    }

    @Column(name="BC_INSS_DEC", precision=15, scale=4)
    public Double getBcInss13() {
        return this.bcInss13;
    }

    public void setBcInss13(Double bcInss13) {
        this.bcInss13 = bcInss13 = Double.valueOf(bcInss13 == null ? 0.0 : bcInss13);
    }

    @Column(nullable=false, name="ALI_INSS_DEC", precision=15, scale=4)
    public Double getAliquotaInss13() {
        return this.aliquotaInss13;
    }

    public void setAliquotaInss13(Double aliquotaInss13) {
        this.aliquotaInss13 = aliquotaInss13 = Double.valueOf(aliquotaInss13 == null ? 0.0 : aliquotaInss13);
    }

    @Column(name="VLR_INSS_DEC", precision=15, scale=4)
    public Double getVlrInss13() {
        return this.vlrInss13;
    }

    public void setVlrInss13(Double vlrInss13) {
        this.vlrInss13 = vlrInss13 = Double.valueOf(vlrInss13 == null ? 0.0 : vlrInss13);
    }

    @Column(nullable=false, name="TOTAL_MEDIA_FERIAS", precision=15, scale=4)
    public Double getTotalMediaFerias() {
        return this.totalMediaFerias;
    }

    public void setTotalMediaFerias(Double totalMediaFerias) {
        this.totalMediaFerias = totalMediaFerias;
    }

    @Column(name="TOTAL_MEDIA_13", precision=15, scale=4)
    public Double getTotalMedia13() {
        return this.totalMedia13;
    }

    public void setTotalMedia13(Double totalMedia13) {
        this.totalMedia13 = totalMedia13;
    }

    @Column(nullable=false, name="TOTAL_MEDIA_AVISO", precision=15, scale=4)
    public Double getTotalMediaAviso() {
        return this.totalMediaAviso;
    }

    public void setTotalMediaAviso(Double totalMediaAviso) {
        this.totalMediaAviso = totalMediaAviso;
    }

    @OneToMany(mappedBy="recisao", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemMovimentoRescisao> getItemRescisao() {
        return this.itemRescisao;
    }

    public void setItemRescisao(List<ItemMovimentoRescisao> itemRescisao) {
        this.itemRescisao = itemRescisao;
    }

    @Column(name="REPOSICAO_VAGA", length=10)
    public String getReposicaoVaga() {
        return this.reposicaoVaga;
    }

    public void setReposicaoVaga(String reposicaoVaga) {
        this.reposicaoVaga = reposicaoVaga;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getColaborador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="TIPO_CONTRATO", length=300)
    public String getTipoContrato() {
        return this.tipoContrato;
    }

    public void setTipoContrato(String tipoContrato) {
        this.tipoContrato = tipoContrato;
    }

    @Column(nullable=false, name="ULTIMA_REMUNERACAO", precision=15, scale=4)
    public Double getUltimaRemuneracao() {
        return this.ultimaRemuneracao;
    }

    public void setUltimaRemuneracao(Double ultimaRemuneracao) {
        this.ultimaRemuneracao = ultimaRemuneracao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_AFASTAMENTO")
    public Date getDataAfastamento() {
        return this.dataAfastamento;
    }

    public void setDataAfastamento(Date dataAfastamento) {
        this.dataAfastamento = dataAfastamento;
    }

    @Column(name="NR_QUOTA", precision=15, scale=4)
    public Double getNrQuota() {
        return this.nrQuota;
    }

    public void setNrQuota(Double nrQuota) {
        this.nrQuota = nrQuota;
    }

    @Column(name="FALTAS_DESCONTO_FERIAS", precision=15, scale=4)
    public Double getFaltasDescontoFerias() {
        return this.faltasDescontoFerias;
    }

    public void setFaltasDescontoFerias(Double faltasDescontoFerias) {
        this.faltasDescontoFerias = faltasDescontoFerias;
    }

    @Column(name="RECISAO_COMPLEMENTAR")
    public Short getRecisaoComplementar() {
        return this.recisaoComplementar;
    }

    public void setRecisaoComplementar(Short recisaoComplementar) {
        this.recisaoComplementar = recisaoComplementar;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="recisaoV", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<MediaRecisaoColaborador> getMediasFeriasVencidas() {
        return this.mediasFeriasVencidas;
    }

    public void setMediasFeriasVencidas(List<MediaRecisaoColaborador> mediasFeriasVencidas) {
        this.mediasFeriasVencidas = mediasFeriasVencidas;
    }

    @Column(name="TOTAL_MEDIA_FERIAS_VENCIDAS", precision=15, scale=4)
    public Double getTotalMediaFeriasVencidas() {
        return this.totalMediaFeriasVencidas;
    }

    public void setTotalMediaFeriasVencidas(Double totalMediaFeriasVencidas) {
        this.totalMediaFeriasVencidas = totalMediaFeriasVencidas;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_INICIAL_FERIAS_VENCIDAS")
    public Date getDataInicialFeriasVencidas() {
        return this.dataInicialFeriasVencidas;
    }

    public void setDataInicialFeriasVencidas(Date dataInicialFeriasVencidas) {
        this.dataInicialFeriasVencidas = dataInicialFeriasVencidas;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FINAL_FERIAS_VENCIDAS")
    public Date getDataFinalFeriasVencidas() {
        return this.dataFinalFeriasVencidas;
    }

    public void setDataFinalFeriasVencidas(Date dataFinalFeriasVencidas) {
        this.dataFinalFeriasVencidas = dataFinalFeriasVencidas;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="ULTIMA_DATA_FERIAS")
    public Date getUltimaDataFerias() {
        return this.ultimaDataFerias;
    }

    public void setUltimaDataFerias(Date ultimaDataFerias) {
        this.ultimaDataFerias = ultimaDataFerias;
    }

    @Column(name="BC_GRRF_SALARIO", precision=15, scale=2)
    public Double getBcGrrfSalario() {
        return this.bcGrrfSalario;
    }

    public void setBcGrrfSalario(Double bcGrrfSalario) {
        this.bcGrrfSalario = bcGrrfSalario;
    }

    @Column(name="ALIQ_GRRF_SALARIO", precision=15, scale=4)
    public Double getAliqGrrfSalario() {
        return this.aliqGrrfSalario;
    }

    public void setAliqGrrfSalario(Double aliqGrrfSalario) {
        this.aliqGrrfSalario = aliqGrrfSalario;
    }

    @Column(nullable=false, name="VLR_GRRF_SALARIO", precision=15, scale=4)
    public Double getVlrGrrfsalario() {
        return this.vlrGrrfsalario;
    }

    public void setVlrGrrfsalario(Double vlrGrrfsalario) {
        this.vlrGrrfsalario = vlrGrrfsalario;
    }

    @Column(name="BC_GRRF_INDENIZADO", precision=15, scale=4)
    public Double getBcGrrfIndenizado() {
        return this.bcGrrfIndenizado;
    }

    public void setBcGrrfIndenizado(Double bcGrrfIndenizado) {
        this.bcGrrfIndenizado = bcGrrfIndenizado;
    }

    @Column(name="ALIQ_GRRF_INDENIZADO", precision=15, scale=4)
    public Double getAliqGrrfIndenizado() {
        return this.aliqGrrfIndenizado;
    }

    public void setAliqGrrfIndenizado(Double aliqGrrfIndenizado) {
        this.aliqGrrfIndenizado = aliqGrrfIndenizado;
    }

    @Column(name="VLR_GRRF_INDENIZADO", precision=15, scale=4)
    public Double getVlrGrrfIndenizado() {
        return this.vlrGrrfIndenizado;
    }

    public void setVlrGrrfIndenizado(Double vlrGrrfIndenizado) {
        this.vlrGrrfIndenizado = vlrGrrfIndenizado;
    }

    @Column(name="VLR_SALDO_FGTS", precision=15, scale=4)
    public Double getVlrSaldoFgts() {
        return this.vlrSaldoFgts;
    }

    public void setVlrSaldoFgts(Double vlrSaldoFgts) {
        this.vlrSaldoFgts = vlrSaldoFgts;
    }

    @Column(name="VLR_MULTA_QUARENTA_POR_CENTO", precision=15, scale=4)
    public Double getVlrMultaQuarentaPorCento() {
        return this.vlrMultaQuarentaPorCento;
    }

    public void setVlrMultaQuarentaPorCento(Double vlrMultaQuarentaPorCento) {
        this.vlrMultaQuarentaPorCento = vlrMultaQuarentaPorCento;
    }

    @Column(name="VLR_MULTA_DEZ_POR_CENTO", precision=15, scale=4)
    public Double getVlrMultaDezPorCento() {
        return this.vlrMultaDezPorCento;
    }

    public void setVlrMultaDezPorCento(Double vlrMultaDezPorCento) {
        this.vlrMultaDezPorCento = vlrMultaDezPorCento;
    }

    @Column(name="VLR_TOTAL_GRRF", precision=15, scale=4)
    public Double getVlrTotalGrrf() {
        return this.vlrTotalGrrf;
    }

    public void setVlrTotalGrrf(Double vlrTotalGrrf) {
        this.vlrTotalGrrf = vlrTotalGrrf;
    }

    @Column(nullable=false, name="VLR_TOTAL_BASE_MES", precision=15, scale=4)
    public Double getVlrTotalBaseMes() {
        return this.vlrTotalBaseMes;
    }

    public void setVlrTotalBaseMes(Double vlrTotalBaseMes) {
        this.vlrTotalBaseMes = vlrTotalBaseMes;
    }

    @Column(nullable=false, name="DIAS_DIREITO_FERIAS_VENCIDAS", precision=15, scale=2)
    public Double getDiasDireitoFeriasVencidas() {
        return this.diasDireitoFeriasVencidas;
    }

    public void setDiasDireitoFeriasVencidas(Double diasDireitoFeriasVencidas) {
        this.diasDireitoFeriasVencidas = diasDireitoFeriasVencidas;
    }

    @Column(name="DIAS_DIREITO_FERIAS_PROPORCIONA", precision=15, scale=2)
    public Double getDiasDireitoFeriasProporcionais() {
        return this.diasDireitoFeriasProporcionais;
    }

    public void setDiasDireitoFeriasProporcionais(Double diasDireitoFeriasProporcionais) {
        this.diasDireitoFeriasProporcionais = diasDireitoFeriasProporcionais;
    }

    @Column(name="VLR_FGTS_MES_ANTERIOR", precision=15, scale=2)
    public Double getVlrFgtsMesAnterior() {
        return this.vlrFgtsMesAnterior;
    }

    public void setVlrFgtsMesAnterior(Double vlrFgtsMesAnterior) {
        this.vlrFgtsMesAnterior = vlrFgtsMesAnterior;
    }

    @Column(name="DIAS_AVISO", precision=15, scale=2)
    public Double getDiasAviso() {
        return this.diasAviso;
    }

    public void setDiasAviso(Double diasAviso) {
        this.diasAviso = diasAviso;
    }

    @Column(name="JRN_SEMANAL_INTEGRAL")
    public Short getJrnSemanalIntegral() {
        return this.jrnSemanalIntegral;
    }

    public void setJrnSemanalIntegral(Short jrnSemanalIntegral) {
        this.jrnSemanalIntegral = jrnSemanalIntegral;
    }

    @Column(name="SABADO_COMPENSADO")
    public Short getSabadoCompensado() {
        return this.sabadoCompensado;
    }

    public void setSabadoCompensado(Short sabadoCompensado) {
        this.sabadoCompensado = sabadoCompensado;
    }

    @Column(name="BC_INSS_SALARIO", precision=15, scale=2)
    public Double getBcInssSalario() {
        return this.bcInssSalario;
    }

    public void setBcInssSalario(Double bcInssSalario) {
        this.bcInssSalario = bcInssSalario;
    }

    @Column(name="BC_INSS_FERIAS", precision=15, scale=2)
    public Double getBcInssFerias() {
        return this.bcInssFerias;
    }

    public void setBcInssFerias(Double bcInssFerias) {
        this.bcInssFerias = bcInssFerias;
    }

    @Column(name="VLR_INSS_SALARIO", precision=15, scale=2)
    public Double getVlrInssSalario() {
        return this.vlrInssSalario;
    }

    public void setVlrInssSalario(Double vlrInssSalario) {
        this.vlrInssSalario = vlrInssSalario;
    }

    @Column(name="VLR_INSS_FERIAS", precision=15, scale=2)
    public Double getVlrInssFerias() {
        return this.vlrInssFerias;
    }

    public void setVlrInssFerias(Double vlrInssFerias) {
        this.vlrInssFerias = vlrInssFerias;
    }

    @Column(name="ALIQ_INSS_SALARIO", precision=15, scale=2)
    public Double getAliqInssSalario() {
        return this.aliqInssSalario;
    }

    public void setAliqInssSalario(Double aliqInssSalario) {
        this.aliqInssSalario = aliqInssSalario;
    }

    @Column(name="ALIQ_INSS_FERIAS", precision=15, scale=2)
    public Double getAliqInssFerias() {
        return this.aliqInssFerias;
    }

    public void setAliqInssFerias(Double aliqInssFerias) {
        this.aliqInssFerias = aliqInssFerias;
    }

    @Column(name="BC_IRRF_FERIAS", precision=15, scale=2)
    public Double getBcIrrfFerias() {
        return this.bcIrrfFerias;
    }

    public void setBcIrrfFerias(Double bcIrrfFerias) {
        this.bcIrrfFerias = bcIrrfFerias;
    }

    @Column(name="VLR_IRRF_FERIAS", precision=15, scale=2)
    public Double getVlrIrrfFerias() {
        return this.vlrIrrfFerias;
    }

    public void setVlrIrrfFerias(Double vlrIrrfFerias) {
        this.vlrIrrfFerias = vlrIrrfFerias;
    }

    @Column(name="ALIQ_IRRF_FERIAS", precision=15, scale=2)
    public Double getAliqIrrfFerias() {
        return this.aliqIrrfFerias;
    }

    public void setAliqIrrfFerias(Double aliqIrrfFerias) {
        this.aliqIrrfFerias = aliqIrrfFerias;
    }

    @Column(name="PERC_PENSAO", precision=15, scale=2)
    public Double getPercPensao() {
        return this.percPensao;
    }

    public void setPercPensao(Double percPensao) {
        this.percPensao = percPensao;
    }

    @Column(name="ALTERAR_IMPOSTO_MANUAL")
    public Short getAlterarImpostoManual() {
        return this.alterarImpostoManual;
    }

    public void setAlterarImpostoManual(Short alterarImpostoManual) {
        this.alterarImpostoManual = alterarImpostoManual;
    }

    @Column(name="VLR_IRRF_FERIAS_GOZADAS", precision=15, scale=4)
    public Double getVlrIrrfFeriasGozadas() {
        return this.vlrIrrfFeriasGozadas;
    }

    public void setVlrIrrfFeriasGozadas(Double vlrIrrfFeriasGozadas) {
        this.vlrIrrfFeriasGozadas = vlrIrrfFeriasGozadas;
    }

    @Column(name="DIAS_UTEIS_DSR", precision=15, scale=4)
    public Double getDiasUteisDRS() {
        return this.diasUteisDRS;
    }

    public void setDiasUteisDRS(Double diasUteisDRS) {
        this.diasUteisDRS = diasUteisDRS;
    }

    @Column(nullable=false, name="DIAS_FOLGAS_FERIADOS_DSR", precision=15, scale=4)
    public Double getDiasFolgasFeriadosDSR() {
        return this.diasFolgasFeriadosDSR;
    }

    public void setDiasFolgasFeriadosDSR(Double diasFolgasFeriadosDSR) {
        this.diasFolgasFeriadosDSR = diasFolgasFeriadosDSR;
    }

    @Column(name="INFORMAR_DIAS_DSR")
    public Short getInformarDiasDSR() {
        return this.informarDiasDSR;
    }

    public void setInformarDiasDSR(Short informarDiasDSR) {
        this.informarDiasDSR = informarDiasDSR;
    }

    @Column(name="DATA_VENCIMENTO_GRRF")
    @Temporal(value=TemporalType.DATE)
    public Date getDataVencimentoGrrf() {
        return this.dataVencimentoGrrf;
    }

    public void setDataVencimentoGrrf(Date dataVencimentoGrrf) {
        this.dataVencimentoGrrf = dataVencimentoGrrf;
    }

    @Column(nullable=false, name="FALTAS_FERIAS_VENCIDAS")
    public Double getFaltasFeriasVencidas() {
        return this.faltasFeriasVencidas;
    }

    public void setFaltasFeriasVencidas(Double faltasFeriasVencidas) {
        this.faltasFeriasVencidas = faltasFeriasVencidas;
    }

    @Column(name="COMPLEMENTAR_COM_DISSIDIO")
    public Short getComplementarComDissidio() {
        return this.complementarComDissidio;
    }

    public void setComplementarComDissidio(Short complementarComDissidio) {
        this.complementarComDissidio = complementarComDissidio;
    }

    @Column(nullable=false, name="BC_IRRF_ANTERIOR", precision=15, scale=2)
    public Double getBcIrrfAnterior() {
        return this.bcIrrfAnterior;
    }

    public void setBcIrrfAnterior(Double bcIrrfAnterior) {
        this.bcIrrfAnterior = bcIrrfAnterior;
    }

    @Column(nullable=false, name="VLR_IRRF_ANTERIOR", precision=15, scale=2)
    public Double getVlrIrrfAnterior() {
        return this.vlrIrrfAnterior;
    }

    public void setVlrIrrfAnterior(Double vlrIrrfAnterior) {
        this.vlrIrrfAnterior = vlrIrrfAnterior;
    }

    @Column(name="AVOS_FERIAS_INDENIZADAS", precision=15, scale=2)
    public Double getAvosFeriasIndenizadas() {
        return this.avosFeriasIndenizadas;
    }

    public void setAvosFeriasIndenizadas(Double avosFeriasIndenizadas) {
        this.avosFeriasIndenizadas = avosFeriasIndenizadas;
    }

    @Column(nullable=false, name="AVOS_DEC_INDENIZADOS", precision=15, scale=2)
    public Double getAvosDecIndenizados() {
        return this.avosDecIndenizados;
    }

    public void setAvosDecIndenizados(Double avosDecIndenizados) {
        this.avosDecIndenizados = avosDecIndenizados;
    }

    @Column(name="INFORMAR_AVOS_MANUALMENTE")
    public Short getInformarAvosManualmente() {
        return this.informarAvosManualmente;
    }

    public void setInformarAvosManualmente(Short informarAvosManualmente) {
        this.informarAvosManualmente = informarAvosManualmente;
    }

    @Column(name="INICIO_CONTAGEM_DEC_IND")
    @Temporal(value=TemporalType.DATE)
    public Date getInicioContagemDecIndenizado() {
        return this.inicioContagemDecIndenizado;
    }

    public void setInicioContagemDecIndenizado(Date inicioContagemDecIndenizado) {
        this.inicioContagemDecIndenizado = inicioContagemDecIndenizado;
    }

    @Column(name="INICIO_CONTAGEM_FERIAS_IND")
    @Temporal(value=TemporalType.DATE)
    public Date getInicioContagemFeriasInd() {
        return this.inicioContagemFeriasInd;
    }

    public void setInicioContagemFeriasInd(Date inicioContagemFeriasInd) {
        this.inicioContagemFeriasInd = inicioContagemFeriasInd;
    }

    @Column(name="VLR_MULTA_VINTE_POR_CENTO", precision=15, scale=2)
    public Double getVlrMultaVintePorCentro() {
        return this.vlrMultaVintePorCentro;
    }

    public void setVlrMultaVintePorCentro(Double vlrMultaVintePorCentro) {
        this.vlrMultaVintePorCentro = vlrMultaVintePorCentro;
    }

    @Column(name="RECISAO_POR_ACORDO")
    public Short getRecisaoPorAcordo() {
        return this.recisaoPorAcordo;
    }

    public void setRecisaoPorAcordo(Short recisaoPorAcordo) {
        this.recisaoPorAcordo = recisaoPorAcordo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMISSAO_AVISO", foreignKey=@ForeignKey(name="FK_RECISAO_EMISSAO_AVISO"))
    public EmissaoAvisoTrabalhado getEmissaoAviso() {
        return this.emissaoAviso;
    }

    public void setEmissaoAviso(EmissaoAvisoTrabalhado emissaoAviso) {
        this.emissaoAviso = emissaoAviso;
    }

    @Column(name="INDICATIVO_PAG_AVISO")
    public Short getIndicativoPagamentoAviso() {
        return this.indicativoPagamentoAviso;
    }

    public void setIndicativoPagamentoAviso(Short indicativoPagamentoAviso) {
        this.indicativoPagamentoAviso = indicativoPagamentoAviso;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INDICATIVO_PENSAO", foreignKey=@ForeignKey(name="FK_RECISAO_INDICATIVO_PENSAO"))
    public EsocIndicativoPensao getIndicativoPensao() {
        return this.indicativoPensao;
    }

    public void setIndicativoPensao(EsocIndicativoPensao indicativoPensao) {
        this.indicativoPensao = indicativoPensao;
    }

    @Column(name="VALOR_PENSAO", precision=15, scale=2)
    public Double getValorPensao() {
        return this.valorPensao;
    }

    public void setValorPensao(Double valorPensao) {
        this.valorPensao = valorPensao;
    }

    @Column(name="NUMERO_CERTIDAO_OBITO", length=100)
    public String getNumeroCertidaoObito() {
        return this.numeroCertidaoObito;
    }

    public void setNumeroCertidaoObito(String numeroCertidaoObito) {
        this.numeroCertidaoObito = numeroCertidaoObito;
    }

    @Column(name="NUMERO_PROC_TRABALHISTA", length=100)
    public String getNumeroProcTrabalhista() {
        return this.numeroProcTrabalhista;
    }

    public void setNumeroProcTrabalhista(String numeroProcTrabalhista) {
        this.numeroProcTrabalhista = numeroProcTrabalhista;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ESOC_CUMP_AVISO", foreignKey=@ForeignKey(name="FK_RECISAO_CUMP_AVISO"))
    public EsocCumprimentoAviso getCumprimentoAviso() {
        return this.cumprimentoAviso;
    }

    public void setCumprimentoAviso(EsocCumprimentoAviso cumprimentoAviso) {
        this.cumprimentoAviso = cumprimentoAviso;
    }

    @Column(name="OBSERVACOES", length=255)
    public String getObservacoes() {
        return this.observacoes;
    }

    public void setObservacoes(String observacoes) {
        this.observacoes = observacoes;
    }

    @OneToOne(mappedBy="recisaoComplementar")
    public RecisaoComplementar getRecisaoComplementarAc() {
        return this.recisaoComplementarAc;
    }

    public void setRecisaoComplementarAc(RecisaoComplementar recisaoComplementarAc) {
        this.recisaoComplementarAc = recisaoComplementarAc;
    }

    @Override
    @OneToMany(mappedBy="recisao", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<EsocPreEvento> getPreEventosEsocial() {
        return this.preEventosEsocial;
    }

    public void setPreEventosEsocial(List<EsocPreEvento> preEventosEsocial) {
        this.preEventosEsocial = preEventosEsocial;
    }

    @OneToMany(mappedBy="recisao", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<Rubricas2299> getRubricas() {
        return this.rubricas;
    }

    public void setRubricas(List<Rubricas2299> rubricas) {
        this.rubricas = rubricas;
    }

    @Column(name="INDENIZAR_AVISO_TRABALHADO")
    public Short getIndenizarAvisoTrabalhado() {
        return this.indenizarAvisoTrabalhado;
    }

    public void setIndenizarAvisoTrabalhado(Short indenizarAvisoTrabalhado) {
        this.indenizarAvisoTrabalhado = indenizarAvisoTrabalhado;
    }

    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    @OneToMany(mappedBy="recisao")
    public List<IntegracaoRecisaoContIntermitente> getConvocacao() {
        return this.convocacao;
    }

    public void setConvocacao(List<IntegracaoRecisaoContIntermitente> convocacao) {
        this.convocacao = convocacao;
    }

    @Column(name="DIAS_CONTRATO_INTERMITENTE", precision=15, scale=2)
    public Double getDiasContratoIntermitente() {
        return this.diasContratoIntermitente;
    }

    public void setDiasContratoIntermitente(Double diasContratoIntermitente) {
        this.diasContratoIntermitente = diasContratoIntermitente;
    }

    @Column(name="AVOS_MATERNIDADE", precision=15, scale=2)
    public Double getAvosDecMaternidade() {
        return this.avosDecMaternidade;
    }

    public void setAvosDecMaternidade(Double avosDecMaternidade) {
        this.avosDecMaternidade = avosDecMaternidade;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="recisao", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<BaseInssEscalonada> getBaseInssEscalonada() {
        return this.baseInssEscalonada;
    }

    public void setBaseInssEscalonada(List<BaseInssEscalonada> baseInssEscalonada) {
        this.baseInssEscalonada = baseInssEscalonada;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_RECESAO_CENTRO_CUSTO"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @Column(name="bc_irrf_plr", precision=15, scale=2)
    public Double getBcIrrfPlr() {
        return this.bcIrrfPlr;
    }

    public void setBcIrrfPlr(Double bcIrrfPlr) {
        this.bcIrrfPlr = bcIrrfPlr;
    }

    @Column(name="numero_faltas_horas", precision=15, scale=2)
    public Double getNumeroFaltasHoras() {
        return this.numeroFaltasHoras;
    }

    public void setNumeroFaltasHoras(Double numeroFaltasHoras) {
        this.numeroFaltasHoras = numeroFaltasHoras;
    }
}

