/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="REGIAO", uniqueConstraints={@UniqueConstraint(name="UNQ1_REGIAO_NOME", columnNames={"NOME"})})
public class Regiao
implements InterfaceVO {
    private Long identificador;
    private String nome;
    private Short ativo = 0;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;

    @Id
    @Column(nullable=false, name="ID_REGIAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_REGIAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(nullable=false, unique=true, name="NOME", length=40)
    public String getNome() {
        return this.nome;
    }

    @Column(nullable=false, name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_REGIAO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setIdentificador(Long idRegiao) {
        this.identificador = idRegiao;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getNome()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }
}

