/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.NotaPropriaComercializacaoRural;
import com.touchcomp.basementor.model.vo.ReinfComercializacaoProducaoRural;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="REINF_CLIENTE_COMERCIALIZACAO_R")
public class ReinfClienteComRural
implements Serializable {
    private Long identificador;
    private ReinfComercializacaoProducaoRural reinfComercializacao;
    private Cliente cliente;
    private Double valorBrutoAquisicao;
    private List<NotaPropriaComercializacaoRural> notas;

    public ReinfClienteComRural() {
        this.valorBrutoAquisicao = 0.0;
        this.notas = new ArrayList<NotaPropriaComercializacaoRural>();
    }

    public ReinfClienteComRural(Cliente cliente) {
        this.cliente = cliente;
        this.valorBrutoAquisicao = 0.0;
        this.notas = new ArrayList<NotaPropriaComercializacaoRural>();
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_REINF_CLIENTE_COM_RURAL")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_REINF_CLIENTE_COM_RURAL")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REINF_COM_PROD_RURAL", foreignKey=@ForeignKey(name="FK_REINF_COM_PROD_RURAL"))
    public ReinfComercializacaoProducaoRural getReinfComercializacao() {
        return this.reinfComercializacao;
    }

    public void setReinfComercializacao(ReinfComercializacaoProducaoRural reinfComercializacao) {
        this.reinfComercializacao = reinfComercializacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLIENTE", foreignKey=@ForeignKey(name="FK_REINF_CLIENTE_PROD_RURAL"))
    public Cliente getCliente() {
        return this.cliente;
    }

    public void setCliente(Cliente cliente) {
        this.cliente = cliente;
    }

    @Column(name="valor_bruto_aquisicao", precision=15, scale=2)
    public Double getValorBrutoAquisicao() {
        return this.valorBrutoAquisicao;
    }

    public void setValorBrutoAquisicao(Double valorBrutoAquisicao) {
        this.valorBrutoAquisicao = valorBrutoAquisicao;
    }

    @OneToMany(mappedBy="cliente", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<NotaPropriaComercializacaoRural> getNotas() {
        return this.notas;
    }

    public void setNotas(List<NotaPropriaComercializacaoRural> notas) {
        this.notas = notas;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

