/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Ncm;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="REINF_COD_ATIVIDADE_ECON", uniqueConstraints={@UniqueConstraint(name="UNQ1_REINF_COD_ATIVID_ECON", columnNames={"CODIGO"})})
public class ReinfCodAtividadeEconomica
implements InterfaceVO {
    private Long identificador;
    private String codigo;
    private String descricao;
    private Double aliquota = 0.0;
    private Date dataInicialEscrituracao;
    private Date dataFinalEscrituracao;
    private List<Ncm> ncm = new ArrayList<Ncm>();

    @Id
    @Column(name="ID_REINF_COD_ATIVIDADE_ECON")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_REINF_COD_ATIVIDADE_ECON")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="CODIGO", length=10)
    public String getCodigo() {
        return this.codigo;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    @Column(name="DESCRICAO", length=500)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(nullable=false, name="ALIQUOTA", precision=12, scale=2)
    public Double getAliquota() {
        return this.aliquota;
    }

    public void setAliquota(Double aliquota) {
        this.aliquota = aliquota;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_INICIAL")
    public Date getDataInicialEscrituracao() {
        return this.dataInicialEscrituracao;
    }

    public void setDataInicialEscrituracao(Date dataInicialEscrituracao) {
        this.dataInicialEscrituracao = dataInicialEscrituracao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FINAL")
    public Date getDataFinalEscrituracao() {
        return this.dataFinalEscrituracao;
    }

    public void setDataFinalEscrituracao(Date dataFinalEscrituracao) {
        this.dataFinalEscrituracao = dataFinalEscrituracao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getCodigo(), this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="reinfCodAtividadeEconomica", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.SAVE_UPDATE, CascadeType.MERGE})
    public List<Ncm> getNcm() {
        return this.ncm;
    }

    public void setNcm(List<Ncm> ncm) {
        this.ncm = ncm;
    }
}

