/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVOReinf;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ReinfClienteComRural;
import com.touchcomp.basementor.model.vo.ReinfPreEvento;
import com.touchcomp.basementor.model.vo.ReinfTipoComercializacao;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="REINF_COMERCIO_PROD_RURAL")
public class ReinfComercializacaoProducaoRural
implements Serializable,
InterfaceVOReinf {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualiazacao;
    private Date periodoReferencia;
    private ReinfTipoComercializacao tipoComercializacaao;
    private List<ReinfClienteComRural> clienteProdRural = new ArrayList<ReinfClienteComRural>();
    private List<ReinfPreEvento> preEventosReinf = new ArrayList<ReinfPreEvento>();

    @Id
    @Column(nullable=false, unique=true, name="ID_REINF_COMERCIALIZACAO_RURAL")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_REINF_COMERCIALIZACAO_RURAL")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_EMP_ESOC_COM_PROD_RURAL"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualiazacao() {
        return this.dataAtualiazacao;
    }

    public void setDataAtualiazacao(Timestamp dataAtualiazacao) {
        this.dataAtualiazacao = dataAtualiazacao;
    }

    @Column(name="PERIODO_REFERENCIA")
    @Temporal(value=TemporalType.DATE)
    public Date getPeriodoReferencia() {
        return this.periodoReferencia;
    }

    public void setPeriodoReferencia(Date periodoReferencia) {
        this.periodoReferencia = periodoReferencia;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REINF_TIPO_COMERCIO", foreignKey=@ForeignKey(name="FK_REINF_TIPO_COMERCIO_RURAL"))
    public ReinfTipoComercializacao getTipoComercializacaao() {
        return this.tipoComercializacaao;
    }

    public void setTipoComercializacaao(ReinfTipoComercializacao tipoComercializacaao) {
        this.tipoComercializacaao = tipoComercializacaao;
    }

    @OneToMany(mappedBy="reinfComercializacao", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ReinfClienteComRural> getClienteProdRural() {
        return this.clienteProdRural;
    }

    public void setClienteProdRural(List<ReinfClienteComRural> clienteProdRural) {
        this.clienteProdRural = clienteProdRural;
    }

    @Override
    @OneToMany(mappedBy="reinfComercializacaoRural", fetch=FetchType.LAZY)
    public List<ReinfPreEvento> getPreEventosReinf() {
        return this.preEventosReinf;
    }

    public void setPreEventosReinf(List<ReinfPreEvento> preEventosReinf) {
        this.preEventosReinf = preEventosReinf;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

