/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.interfaces.InterfaceVOReinf;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ReinfPreEvento;
import com.touchcomp.basementor.model.vo.ReinfR2060Item;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="REINF_R_2060")
public class ReinfR2060
implements InterfaceVO,
InterfaceVOReinf {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Date periodo;
    private Double valorReceitaBrutaTotal = 0.0;
    private Double valorContribPrevTotal = 0.0;
    private Double valorContribPrevSuspensao = 0.0;
    private List<ReinfR2060Item> itens = new ArrayList<ReinfR2060Item>();
    private Empresa empresa;
    private List<ReinfPreEvento> preEventosReinf = new ArrayList<ReinfPreEvento>();

    @Id
    @Column(nullable=false, unique=true, name="ID_REINF_R_2060")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_REINF_R_2060")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="PERIODO")
    @Temporal(value=TemporalType.DATE)
    public Date getPeriodo() {
        return this.periodo;
    }

    public void setPeriodo(Date periodo) {
        this.periodo = periodo;
    }

    @Column(name="VALOR_RECEITA_BRUTA_TOTAL", precision=15, scale=2)
    public Double getValorReceitaBrutaTotal() {
        return this.valorReceitaBrutaTotal;
    }

    public void setValorReceitaBrutaTotal(Double valorReceitaBrutaTotal) {
        this.valorReceitaBrutaTotal = valorReceitaBrutaTotal;
    }

    @Column(name="VALOR_CONTRIB_PREV_TOTAL", precision=15, scale=2)
    public Double getValorContribPrevTotal() {
        return this.valorContribPrevTotal;
    }

    public void setValorContribPrevTotal(Double valorContribPrevTotal) {
        this.valorContribPrevTotal = valorContribPrevTotal;
    }

    @Column(name="VALOR_CONTRIB_PREV_SUSP", precision=15, scale=2)
    public Double getValorContribPrevSuspensao() {
        return this.valorContribPrevSuspensao;
    }

    public void setValorContribPrevSuspensao(Double valorContribPrevSuspensao) {
        this.valorContribPrevSuspensao = valorContribPrevSuspensao;
    }

    @OneToMany(mappedBy="r2060", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ReinfR2060Item> getItens() {
        return this.itens;
    }

    public void setItens(List<ReinfR2060Item> itens) {
        this.itens = itens;
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_REINF_R_2060_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Override
    @OneToMany(mappedBy="r2060", fetch=FetchType.LAZY)
    public List<ReinfPreEvento> getPreEventosReinf() {
        return this.preEventosReinf;
    }

    public void setPreEventosReinf(List<ReinfPreEvento> preEventosReinf) {
        this.preEventosReinf = preEventosReinf;
    }
}

