/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FormaPagtoCte;
import com.touchcomp.basementor.model.vo.ItemCompFreteRemDest;
import com.touchcomp.basementor.model.vo.RemDestFretePcaPedagio;
import com.touchcomp.basementor.model.vo.RotaApoio;
import com.touchcomp.basementor.model.vo.TabelaCalculoFrete;
import com.touchcomp.basementor.model.vo.TipoOperacao;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.UnidadeFatTransporte;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="REMETENTE_DESTINATARIO", uniqueConstraints={@UniqueConstraint(name="UNQ1_REMETENTE_DESTINATARIO", columnNames={"ID_UNIDADE_FAT_TRANSPORTE_REMET", "ID_UNIDADE_FAT_TRANSPORTE_DEST", "ID_UNIDADE_FAT_CLIENTE_TOMADOR"})})
public class RemetenteDestinatarioFrete
implements InterfaceVO {
    private Long identificador;
    private UnidadeFatTransporte pessoaRemetente;
    private UnidadeFatTransporte pessoaDestinatario;
    private Double distanciaKm = 0.0;
    private TipoOperacao tipoOperacaoFrete;
    private RotaApoio rotaApoio;
    private List<RemDestFretePcaPedagio> remDestFretePcaPedagio = new ArrayList<RemDestFretePcaPedagio>();
    private List<ItemCompFreteRemDest> componentesFrete = new ArrayList<ItemCompFreteRemDest>();
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private CategoriaPessoa categoriaPessoa;
    private FormaPagtoCte formaPagtoCte;
    private Short tipoCalcFrete = 0;
    private TabelaCalculoFrete tabelaFrete;
    private UnidadeFatCliente tomador;
    private Short usarDescrAuxRem = 0;
    private String descrAuxRem;
    private Short usarDescrAuxDest = 0;
    private String descrAuxDest;
    private Short ativo = 1;

    @Id
    @Column(nullable=false, name="ID_REMETENTE_DESTINATARIO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_REMETENTE_DESTINATARIO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNIDADE_FAT_TRANSPORTE_REMET", foreignKey=@ForeignKey(name="FK_REMETENTE_DEST_UN_T_REMET"))
    public UnidadeFatTransporte getPessoaRemetente() {
        return this.pessoaRemetente;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNIDADE_FAT_TRANSPORTE_DEST", foreignKey=@ForeignKey(name="FK_REMETENTE_DEST_UN_T_DEST"))
    public UnidadeFatTransporte getPessoaDestinatario() {
        return this.pessoaDestinatario;
    }

    @Column(nullable=false, name="DISTANCIA_KM", precision=15, scale=3)
    public Double getDistanciaKm() {
        return this.distanciaKm;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_OPERACAO_FRETE", foreignKey=@ForeignKey(name="FK_REMETENTE_DEST_TP_OP_FRETE"))
    public TipoOperacao getTipoOperacaoFrete() {
        return this.tipoOperacaoFrete;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ROTA_APOIO", foreignKey=@ForeignKey(name="FK_REMETENTE_DEST_ROTA_APOIO"))
    public RotaApoio getRotaApoio() {
        return this.rotaApoio;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_REMETENTE_DEST_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @OneToMany(mappedBy="remetenteDestinatarioFrete", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<RemDestFretePcaPedagio> getRemDestFretePcaPedagio() {
        return this.remDestFretePcaPedagio;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setPessoaRemetente(UnidadeFatTransporte pessoaRemetente) {
        this.pessoaRemetente = pessoaRemetente;
    }

    public void setPessoaDestinatario(UnidadeFatTransporte pessoaDestinatario) {
        this.pessoaDestinatario = pessoaDestinatario;
    }

    public void setDistanciaKm(Double distanciaKm) {
        this.distanciaKm = distanciaKm;
    }

    public void setTipoOperacaoFrete(TipoOperacao tipoOperacaoFrete) {
        this.tipoOperacaoFrete = tipoOperacaoFrete;
    }

    public void setRotaApoio(RotaApoio rotaApoio) {
        this.rotaApoio = rotaApoio;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setRemDestFretePcaPedagio(List<RemDestFretePcaPedagio> remDestFretePcaPedagio) {
        this.remDestFretePcaPedagio = remDestFretePcaPedagio;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CATEGORIA_PESSOA", foreignKey=@ForeignKey(name="FK_REMETENTE_DEST_CAT_PESSOA"))
    public CategoriaPessoa getCategoriaPessoa() {
        return this.categoriaPessoa;
    }

    public void setCategoriaPessoa(CategoriaPessoa categoriaPessoa) {
        this.categoriaPessoa = categoriaPessoa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FORMA_PAGTO_CTE", foreignKey=@ForeignKey(name="FK_REMETENTE_DEST_FORMA_PAG_CTE"))
    public FormaPagtoCte getFormaPagtoCte() {
        return this.formaPagtoCte;
    }

    public void setFormaPagtoCte(FormaPagtoCte formaPagtoCte) {
        this.formaPagtoCte = formaPagtoCte;
    }

    @Column(name="TIPO_CALC_FRETE")
    public Short getTipoCalcFrete() {
        return this.tipoCalcFrete;
    }

    public void setTipoCalcFrete(Short tipoCalcFrete) {
        this.tipoCalcFrete = tipoCalcFrete;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TABELA_CALC_FRETE", foreignKey=@ForeignKey(name="FK_REMETENTE_DEST_TAB_CALC_FRET"))
    public TabelaCalculoFrete getTabelaFrete() {
        return this.tabelaFrete;
    }

    public void setTabelaFrete(TabelaCalculoFrete tabelaFrete) {
        this.tabelaFrete = tabelaFrete;
    }

    @OneToMany(mappedBy="remDestFrete", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ItemCompFreteRemDest> getComponentesFrete() {
        return this.componentesFrete;
    }

    public void setComponentesFrete(List<ItemCompFreteRemDest> componentesFrete) {
        this.componentesFrete = componentesFrete;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNIDADE_FAT_CLIENTE_TOMADOR", foreignKey=@ForeignKey(name="FK_REMETENTE_DEST_UN_FAT_CLI"))
    public UnidadeFatCliente getTomador() {
        return this.tomador;
    }

    public void setTomador(UnidadeFatCliente tomador) {
        this.tomador = tomador;
    }

    @Column(name="USAR_DESCR_AUX_REM")
    public Short getUsarDescrAuxRem() {
        return this.usarDescrAuxRem;
    }

    public void setUsarDescrAuxRem(Short usarDescrAuxRem) {
        this.usarDescrAuxRem = usarDescrAuxRem;
    }

    @Column(name="DESCR_AUX_REM", length=60)
    public String getDescrAuxRem() {
        return this.descrAuxRem;
    }

    public void setDescrAuxRem(String descrAuxRem) {
        this.descrAuxRem = descrAuxRem;
    }

    @Column(name="USAR_DESCR_AUX_DEST")
    public Short getUsarDescrAuxDest() {
        return this.usarDescrAuxDest;
    }

    public void setUsarDescrAuxDest(Short usarDescrAuxDest) {
        this.usarDescrAuxDest = usarDescrAuxDest;
    }

    @Column(name="DESCR_AUX_DEST", length=60)
    public String getDescrAuxDest() {
        return this.descrAuxDest;
    }

    public void setDescrAuxDest(String descrAuxDest) {
        this.descrAuxDest = descrAuxDest;
    }

    @Column(nullable=false, name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }
}

