/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.bi.EnumConstTipoRepositorioBI;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ImportacaoBi;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.VersaoRepositorioBI;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="REPOSITORIO_BI")
public class RepositorioBi
implements InterfaceVO {
    private static final long serialVersionUID = 1L;
    private Long identificador;
    private Pessoa pessoaResponsavel;
    private List<Nodo> nodos = new ArrayList<Nodo>();
    private Date dataUltimaModificacao;
    private Short tipoBi = 0;
    private String descricao;
    private String nomeBi;
    private String alteracao;
    private ImportacaoBi importacaoBi;
    private List<VersaoRepositorioBI> versaosRepositorioBI = new ArrayList<VersaoRepositorioBI>();
    private Long numeroVersao = 0L;
    private Short inativo = 0;
    private Short tipo = EnumConstTipoRepositorioBI.BI.getValue();

    @Id
    @Column(nullable=false, unique=true, name="ID_REPOSITORIO_BI")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_REPOSITORIO_BI")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_RESPONSAVEL", foreignKey=@ForeignKey(name="FK_REPOSITORIO_BI_1"))
    @Cascade(value={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.SAVE_UPDATE})
    public Pessoa getPessoaResponsavel() {
        return this.pessoaResponsavel;
    }

    public void setPessoaResponsavel(Pessoa pessoaResponsavel) {
        this.pessoaResponsavel = pessoaResponsavel;
    }

    @OneToMany(fetch=FetchType.LAZY)
    @JoinTable(name="repositorio_bi_nodos", joinColumns={@JoinColumn(name="ID_REPOSITORIO_BI")}, inverseJoinColumns={@JoinColumn(name="ID_NODO")})
    public List<Nodo> getNodos() {
        return this.nodos;
    }

    public void setNodos(List<Nodo> nodos) {
        this.nodos = nodos;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ULTIMA_MODIFICACAO")
    public Date getDataUltimaModificacao() {
        return this.dataUltimaModificacao;
    }

    public void setDataUltimaModificacao(Date dataUltimaModificacao) {
        this.dataUltimaModificacao = dataUltimaModificacao;
    }

    @Column(name="TIPO_BI")
    public Short getTipoBi() {
        return this.tipoBi;
    }

    @Column(name="DESCRICAO", length=5000)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="NOME_BI", length=1000)
    public String getNomeBi() {
        return this.nomeBi;
    }

    public void setNomeBi(String nomeBi) {
        this.nomeBi = nomeBi;
    }

    @Column(name="ALTERACAO", length=5000)
    public String getAlteracao() {
        return this.alteracao;
    }

    public void setAlteracao(String alteracao) {
        this.alteracao = alteracao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @JoinColumn(name="ID_IMPORTACAO_BI", foreignKey=@ForeignKey(name="FK_REPOSITORIO_BI_2"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ImportacaoBi getImportacaoBi() {
        return this.importacaoBi;
    }

    public void setImportacaoBi(ImportacaoBi importacaoBi) {
        this.importacaoBi = importacaoBi;
    }

    @OneToMany(mappedBy="repositorioBI")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    @OrderBy(value="numeroVersao")
    public List<VersaoRepositorioBI> getVersaosRepositorioBI() {
        return this.versaosRepositorioBI;
    }

    public void setVersaosRepositorioBI(List<VersaoRepositorioBI> versaosRepositorioBI) {
        this.versaosRepositorioBI = versaosRepositorioBI;
    }

    @Column(name="NUMERO_VERSAO")
    public Long getNumeroVersao() {
        return this.numeroVersao;
    }

    public void setNumeroVersao(Long numeroVersao) {
        this.numeroVersao = numeroVersao;
    }

    @Column(name="INATIVO")
    public Short getInativo() {
        return this.inativo;
    }

    public void setInativo(Short inativo) {
        this.inativo = inativo;
    }

    public void setTipoBi(Short tipoBi) {
        this.tipoBi = tipoBi;
    }

    @Column(name="TIPO")
    public Short getTipo() {
        return this.tipo;
    }

    public void setTipo(Short tipo) {
        this.tipo = tipo;
    }
}

