/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ApuracidadeEstoque;
import com.touchcomp.basementor.model.vo.AtendPedidoAlmox;
import com.touchcomp.basementor.model.vo.ControleEntregaEquipamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EventoOsProducaoLinhaProd;
import com.touchcomp.basementor.model.vo.ItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.ItemEventoOsProdSobEnc;
import com.touchcomp.basementor.model.vo.ItemRequisicao;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="REQUISICAO", uniqueConstraints={@UniqueConstraint(name="UNQ1_REQUISICAO", columnNames={"ID_NOTA_FISCAL_TERC"})})
public class Requisicao
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Date dataRequisicao;
    private NotaFiscalTerceiros notaFiscalTerc;
    private EventoOsProducaoLinhaProd eventoOsProducaoLinhaProd;
    private ItemEventoOsProdSobEnc itemEventoOsProdSobEnc;
    private Empresa empresa;
    private List<ItemRequisicao> itensRequisicao = new ArrayList<ItemRequisicao>();
    private String observacao;
    private ApuracidadeEstoque apuracidadeEstoque;
    private AtendPedidoAlmox atendPedidoAlmox;
    private Short tipoRequisicao = 0;
    private ItemComunicadoProducao itemComunicadoProducao;
    private ControleEntregaEquipamento controleEntregaEquipamento;

    @Id
    @Column(nullable=false, name="ID_REQUISICAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_REQUISICAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_REQUISICAO")
    public Date getDataRequisicao() {
        return this.dataRequisicao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NOTA_FISCAL_TERC", foreignKey=@ForeignKey(name="FK_REQUISICAO_NF_TERCEIROS"))
    public NotaFiscalTerceiros getNotaFiscalTerc() {
        return this.notaFiscalTerc;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EVENTO_OS_PROD_LIN_PROD", foreignKey=@ForeignKey(name="FK_REQUISICAO_EVT_OS_LINHA_PROD"))
    public EventoOsProducaoLinhaProd getEventoOsProducaoLinhaProd() {
        return this.eventoOsProducaoLinhaProd;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_REQUISICAO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @OneToMany(mappedBy="requisicao", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemRequisicao> getItensRequisicao() {
        return this.itensRequisicao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setDataRequisicao(Date dataRequisicao) {
        this.dataRequisicao = dataRequisicao;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setEventoOsProducaoLinhaProd(EventoOsProducaoLinhaProd eventoOsProducaoLinhaProd) {
        this.eventoOsProducaoLinhaProd = eventoOsProducaoLinhaProd;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setNotaFiscalTerc(NotaFiscalTerceiros notaFiscalTerc) {
        this.notaFiscalTerc = notaFiscalTerc;
    }

    public void setItensRequisicao(List<ItemRequisicao> itensRequisicao) {
        this.itensRequisicao = itensRequisicao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        if (this.getDataRequisicao() != null) {
            if (this.getObservacao() != null) {
                return ToolBaseMethodsVO.toString((String)"{0} - {1} - {2}", (Object[])new Object[]{this.getIdentificador(), ToolDate.dateToStr((Date)this.getDataRequisicao()), this.getObservacao()});
            }
            return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), ToolDate.dateToStr((Date)this.getDataRequisicao())});
        }
        if (this.getObservacao() != null) {
            return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getObservacao()});
        }
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="OBSERVACAO", length=500)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @OneToOne(mappedBy="requisicao", fetch=FetchType.LAZY)
    public ApuracidadeEstoque getApuracidadeEstoque() {
        return this.apuracidadeEstoque;
    }

    public void setApuracidadeEstoque(ApuracidadeEstoque apuracidadeEstoque) {
        this.apuracidadeEstoque = apuracidadeEstoque;
    }

    @OneToOne(mappedBy="requisicao", fetch=FetchType.LAZY)
    public AtendPedidoAlmox getAtendPedidoAlmox() {
        return this.atendPedidoAlmox;
    }

    public void setAtendPedidoAlmox(AtendPedidoAlmox atendPedidoAlmox) {
        this.atendPedidoAlmox = atendPedidoAlmox;
    }

    @Column(name="TIPO_REQUISICAO")
    public Short getTipoRequisicao() {
        return this.tipoRequisicao;
    }

    public void setTipoRequisicao(Short tipoRequisicao) {
        this.tipoRequisicao = tipoRequisicao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ITEM_COMUNICADO_PRODUCAO", foreignKey=@ForeignKey(name="FK_REQUISICAO_ITEM_COM_PROD"))
    public ItemComunicadoProducao getItemComunicadoProducao() {
        return this.itemComunicadoProducao;
    }

    public void setItemComunicadoProducao(ItemComunicadoProducao itemComunicadoProducao) {
        this.itemComunicadoProducao = itemComunicadoProducao;
    }

    @OneToOne(mappedBy="requisicao", fetch=FetchType.LAZY)
    public ItemEventoOsProdSobEnc getItemEventoOsProdSobEnc() {
        return this.itemEventoOsProdSobEnc;
    }

    public void setItemEventoOsProdSobEnc(ItemEventoOsProdSobEnc itemEventoOsProdSobEnc) {
        this.itemEventoOsProdSobEnc = itemEventoOsProdSobEnc;
    }

    @OneToOne(mappedBy="requisicao", fetch=FetchType.LAZY)
    public ControleEntregaEquipamento getControleEntregaEquipamento() {
        return this.controleEntregaEquipamento;
    }

    public void setControleEntregaEquipamento(ControleEntregaEquipamento controleEntregaEquipamento) {
        this.controleEntregaEquipamento = controleEntregaEquipamento;
    }
}

