/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixa;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementor.model.vo.ItemRetornoCnab;
import com.touchcomp.basementor.model.vo.RetornoCnabCobrancaObservacao;
import com.touchcomp.basementor.model.vo.RetornoCnabCobrancaTitulosAntNaoGerado;
import com.touchcomp.basementor.model.vo.RetornoCnabCobrancaTitulosNaoBaixados;
import com.touchcomp.basementor.model.vo.TipoCnab;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="ARQUIVO_RETORNO_CNAB")
public class RetornoCnabCobranca
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private GrupoDeBaixa grupoBaixa;
    private Date dataReferenciaRetorno;
    private Timestamp dataAtualizacao;
    private InstituicaoValores instituicaoValores;
    private TipoCnab tipoCnab;
    private String nomeArquivo;
    private List<RetornoCnabCobrancaObservacao> observacoes = new ArrayList<RetornoCnabCobrancaObservacao>();
    private List<RetornoCnabCobrancaTitulosNaoBaixados> titulosNaoBaixados = new ArrayList<RetornoCnabCobrancaTitulosNaoBaixados>();
    private Short gerarTituloAntecipado = 1;
    private List<RetornoCnabCobrancaTitulosAntNaoGerado> titulosAntecipadosNaoBaixados = new ArrayList<RetornoCnabCobrancaTitulosAntNaoGerado>();
    private List<ItemRetornoCnab> itensRetornoCnab = new ArrayList<ItemRetornoCnab>();

    @Id
    @Column(nullable=false, unique=true, name="ID_ARQUIVO_RETORNO_CNAB")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ARQUIVO_RETORNO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ARQUIVO_RET_CNAB_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    @JoinColumn(name="ID_GRUPO_BAIXA", foreignKey=@ForeignKey(name="FK_ARQUIVO_RET_CNAB_GR_BAIXA"))
    public GrupoDeBaixa getGrupoBaixa() {
        return this.grupoBaixa;
    }

    public void setGrupoBaixa(GrupoDeBaixa grupoBaixa) {
        this.grupoBaixa = grupoBaixa;
    }

    @Column(nullable=true, name="DATA_REFERENCIA_RETORNO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataReferenciaRetorno() {
        return this.dataReferenciaRetorno;
    }

    public void setDataReferenciaRetorno(Date dataReferenciaRetorno) {
        this.dataReferenciaRetorno = dataReferenciaRetorno;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INSTITUICAO_VALORES", foreignKey=@ForeignKey(name="FK_ARQUIVO_RET_CNAB_INT_VAL"))
    public InstituicaoValores getInstituicaoValores() {
        return this.instituicaoValores;
    }

    public void setInstituicaoValores(InstituicaoValores instituicaoValores) {
        this.instituicaoValores = instituicaoValores;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_CNAB", foreignKey=@ForeignKey(name="FK_ARQ_RET_CNAB_TIPO_CNAB"))
    public TipoCnab getTipoCnab() {
        return this.tipoCnab;
    }

    public void setTipoCnab(TipoCnab tipoCnab) {
        this.tipoCnab = tipoCnab;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="NOME_ARQUIVO", length=100)
    public String getNomeArquivo() {
        return this.nomeArquivo;
    }

    public void setNomeArquivo(String nomeArquivo) {
        this.nomeArquivo = nomeArquivo;
    }

    @OneToMany(mappedBy="retornoCnabCobranca", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<RetornoCnabCobrancaObservacao> getObservacoes() {
        return this.observacoes;
    }

    public void setObservacoes(List<RetornoCnabCobrancaObservacao> observacoes) {
        this.observacoes = observacoes;
    }

    @OneToMany(mappedBy="retornoCnabCobranca", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<RetornoCnabCobrancaTitulosNaoBaixados> getTitulosNaoBaixados() {
        return this.titulosNaoBaixados;
    }

    public void setTitulosNaoBaixados(List<RetornoCnabCobrancaTitulosNaoBaixados> titulosNaoBaixados) {
        this.titulosNaoBaixados = titulosNaoBaixados;
    }

    @Column(name="GERAR_TITULO_ANTECIPADO")
    public Short getGerarTituloAntecipado() {
        return this.gerarTituloAntecipado;
    }

    public void setGerarTituloAntecipado(Short gerarTituloAntecipado) {
        this.gerarTituloAntecipado = gerarTituloAntecipado;
    }

    @OneToMany(mappedBy="retornoCnabCobranca", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<RetornoCnabCobrancaTitulosAntNaoGerado> getTitulosAntecipadosNaoBaixados() {
        return this.titulosAntecipadosNaoBaixados;
    }

    public void setTitulosAntecipadosNaoBaixados(List<RetornoCnabCobrancaTitulosAntNaoGerado> titulosAntecipadosNaoBaixados) {
        this.titulosAntecipadosNaoBaixados = titulosAntecipadosNaoBaixados;
    }

    @OneToMany(mappedBy="retornoCnabCobranca", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemRetornoCnab> getItensRetornoCnab() {
        return this.itensRetornoCnab;
    }

    public void setItensRetornoCnab(List<ItemRetornoCnab> itensRetornoCnab) {
        this.itensRetornoCnab = itensRetornoCnab;
    }
}

