/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.RotaApoioCidade;
import com.touchcomp.basementor.model.vo.RotaApoioPessoa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="ROTA_APOIO", uniqueConstraints={@UniqueConstraint(name="UNQ1_ROTA_APOIO", columnNames={"DESCRICAO"})})
public class RotaApoio {
    private Long identificador;
    private String descricao;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private List<RotaApoioCidade> rotasApoioCidade = new ArrayList<RotaApoioCidade>();
    private List<RotaApoioPessoa> rotasApoioPessoa = new ArrayList<RotaApoioPessoa>();
    private Empresa empresa;

    @Id
    @Column(nullable=false, name="ID_ROTA_APOIO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ROTA_APOIO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(unique=true, nullable=false, name="DESCRICAO", length=100)
    public String getDescricao() {
        return this.descricao;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @OneToMany(mappedBy="rotaApoio", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<RotaApoioCidade> getRotasApoioCidade() {
        return this.rotasApoioCidade;
    }

    public void setRotasApoioCidade(List<RotaApoioCidade> rotasApoioCidade) {
        this.rotasApoioCidade = rotasApoioCidade;
    }

    @OneToMany(mappedBy="rotaApoio", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<RotaApoioPessoa> getRotasApoioPessoa() {
        return this.rotasApoioPessoa;
    }

    public void setRotasApoioPessoa(List<RotaApoioPessoa> rotasApoioPessoa) {
        this.rotasApoioPessoa = rotasApoioPessoa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ROTA_APOIO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

