/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FaseProdutiva;
import com.touchcomp.basementor.model.vo.FichaTecRoteiroProducao;
import com.touchcomp.basementor.model.vo.GrupoProdutoRoteiroProducao;
import com.touchcomp.basementor.model.vo.RoteiroProducaoGrCor;
import com.touchcomp.basementor.model.vo.RoteiroProducaoTpProdSped;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="ROTEIRO_PRODUCAO")
public class RoteiroProducao
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private String descricao;
    private Empresa empresa;
    private List<FaseProdutiva> fasesProdutivas;
    private List<RoteiroProducaoGrCor> roteiroProducaoGrCor = new ArrayList<RoteiroProducaoGrCor>();
    private Short ativo;
    private Short dividirTempoNrGrades;
    private List<GrupoProdutoRoteiroProducao> grupoProdutos;
    private List<FichaTecRoteiroProducao> fichasTecnicas;
    private Short principal;
    private List<RoteiroProducaoTpProdSped> tiposProducaoSped;
    private Short naoCalcTempoInfMan;
    private String revisao;

    public RoteiroProducao() {
        this.fasesProdutivas = new ArrayList<FaseProdutiva>();
        this.ativo = EnumConstantsMentorSimNao.SIM.getValue();
        this.principal = EnumConstantsMentorSimNao.SIM.getValue();
        this.dividirTempoNrGrades = EnumConstantsMentorSimNao.NAO.getValue();
        this.grupoProdutos = new ArrayList<GrupoProdutoRoteiroProducao>();
        this.fichasTecnicas = new ArrayList<FichaTecRoteiroProducao>();
        this.tiposProducaoSped = new ArrayList<RoteiroProducaoTpProdSped>();
        this.naoCalcTempoInfMan = EnumConstantsMentorSimNao.NAO.getValue();
    }

    @Id
    @Column(nullable=false, name="ID_ROTEIRO_PRODUCAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ROTEIRO_PRODUCAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ROTEIRO_PRODUCAO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @OneToMany(mappedBy="roteiroProducao", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @OrderBy(value="numeroOrdem")
    public List<FaseProdutiva> getFasesProdutivas() {
        return this.fasesProdutivas;
    }

    public void setFasesProdutivas(List<FaseProdutiva> fasesProdutivas) {
        this.fasesProdutivas = fasesProdutivas;
    }

    @Column(name="DESCRICAO", length=300)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @OneToMany(mappedBy="roteiroProducao", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<RoteiroProducaoGrCor> getRoteiroProducaoGrCor() {
        return this.roteiroProducaoGrCor;
    }

    public void setRoteiroProducaoGrCor(List<RoteiroProducaoGrCor> roteiroProducaoGrCor) {
        this.roteiroProducaoGrCor = roteiroProducaoGrCor;
    }

    @Column(name="DIVIDIR_TEMPO_NR_GRADES")
    public Short getDividirTempoNrGrades() {
        return this.dividirTempoNrGrades;
    }

    public void setDividirTempoNrGrades(Short dividirTempoNrGrades) {
        this.dividirTempoNrGrades = dividirTempoNrGrades;
    }

    @OneToMany(mappedBy="roteiroProducao")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<GrupoProdutoRoteiroProducao> getGrupoProdutos() {
        return this.grupoProdutos;
    }

    public void setGrupoProdutos(List<GrupoProdutoRoteiroProducao> grupoProdutos) {
        this.grupoProdutos = grupoProdutos;
    }

    @OneToMany(mappedBy="roteiroProducao")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<FichaTecRoteiroProducao> getFichasTecnicas() {
        return this.fichasTecnicas;
    }

    public void setFichasTecnicas(List<FichaTecRoteiroProducao> fichasTecnicas) {
        this.fichasTecnicas = fichasTecnicas;
    }

    @Column(name="PRINCIPAL")
    public Short getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Short principal) {
        this.principal = principal;
    }

    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="roteiroProducao")
    public List<RoteiroProducaoTpProdSped> getTiposProducaoSped() {
        return this.tiposProducaoSped;
    }

    public void setTiposProducaoSped(List<RoteiroProducaoTpProdSped> tiposProducaoSped) {
        this.tiposProducaoSped = tiposProducaoSped;
    }

    @Column(name="NAO_CAL_TEMPO_INF_MAN")
    public Short getNaoCalcTempoInfMan() {
        return this.naoCalcTempoInfMan;
    }

    public void setNaoCalcTempoInfMan(Short naoCalcTempoInfMan) {
        this.naoCalcTempoInfMan = naoCalcTempoInfMan;
    }

    @Column(name="REVISAO")
    public String getRevisao() {
        return this.revisao;
    }

    public void setRevisao(String revisao) {
        this.revisao = revisao;
    }
}

