/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.SecfContaParteBLacs;
import com.touchcomp.basementor.model.vo.SecfContabilParteALacs;
import com.touchcomp.basementor.model.vo.SecfTabelaDinamica;
import com.touchcomp.basementor.model.vo.SpedEcf;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="SECF_LANC_PARTE_A_LACS")
public class SecfLancParteALacs
implements InterfaceVO {
    private Long identificador;
    private SecfTabelaDinamica tabelaDinamica;
    private Date periodo;
    private Double valor = 0.0;
    private SpedEcf spedEcf;
    private Short tipoLancamento = 0;
    private Short indicadorRelacao = 0;
    private String historico;
    private Short tipo = 0;
    private List<SecfContaParteBLacs> registrosM355 = new ArrayList<SecfContaParteBLacs>();
    private List<SecfContabilParteALacs> registrosM360 = new ArrayList<SecfContabilParteALacs>();

    @Id
    @Column(nullable=false, name="ID_SECF_LANC_PARTE_A_LACS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_SECF_LANC_PARTE_A_LACS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, name="VALOR", precision=15, scale=2)
    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SPED_ECF", foreignKey=@ForeignKey(name="FK_SECF_LANC_PART_A_LACS_SPED_E"))
    public SpedEcf getSpedEcf() {
        return this.spedEcf;
    }

    public void setSpedEcf(SpedEcf spedEcf) {
        this.spedEcf = spedEcf;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @JoinColumn(name="ID_SECF_TABELA_DINAMICA", foreignKey=@ForeignKey(name="FK_SECF_LANC_PART_A_LACS_TAB_DI"))
    @ManyToOne(fetch=FetchType.LAZY)
    public SecfTabelaDinamica getTabelaDinamica() {
        return this.tabelaDinamica;
    }

    public void setTabelaDinamica(SecfTabelaDinamica tabelaDinamica) {
        this.tabelaDinamica = tabelaDinamica;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="PERIODO")
    public Date getPeriodo() {
        return this.periodo;
    }

    public void setPeriodo(Date periodo) {
        this.periodo = periodo;
    }

    @Column(name="TIPO_LANCAMENTO")
    public Short getTipoLancamento() {
        return this.tipoLancamento;
    }

    public void setTipoLancamento(Short tipoLancamento) {
        this.tipoLancamento = tipoLancamento;
    }

    @Column(name="IND_RELACAO")
    public Short getIndicadorRelacao() {
        return this.indicadorRelacao;
    }

    public void setIndicadorRelacao(Short indicadorRelacao) {
        this.indicadorRelacao = indicadorRelacao;
    }

    @Column(name="HISTORICO", length=500)
    public String getHistorico() {
        return this.historico;
    }

    public void setHistorico(String historico) {
        this.historico = historico;
    }

    @Column(name="TIPO")
    public Short getTipo() {
        return this.tipo;
    }

    public void setTipo(Short tipo) {
        this.tipo = tipo;
    }

    @OneToMany(mappedBy="secfLancParteALacs", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    public List<SecfContaParteBLacs> getRegistrosM355() {
        return this.registrosM355;
    }

    public void setRegistrosM355(List<SecfContaParteBLacs> registrosM355) {
        this.registrosM355 = registrosM355;
    }

    @OneToMany(mappedBy="secfLancParteALacs", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    public List<SecfContabilParteALacs> getRegistrosM360() {
        return this.registrosM360;
    }

    public void setRegistrosM360(List<SecfContabilParteALacs> registrosM360) {
        this.registrosM360 = registrosM360;
    }
}

