/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.situacaocotacaovendas.EnumTipoSituacaoVendas;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;

@Entity
@Table(name="SITUACAO_COTACAO_VENDAS", uniqueConstraints={@UniqueConstraint(name="UNQ1_SITUACAO_COTACAO_VENDAS", columnNames={"DESCRICAO"})})
public class SituacaoCotacaoVendas
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Short tipoCotacao;
    private String descricao;
    private Double percAvanco;
    private Short ativo;
    private Short utilizarCotVenda;
    private Short utilizarPreCotVenda;

    public SituacaoCotacaoVendas() {
        this.tipoCotacao = EnumTipoSituacaoVendas.CANCELADA.value;
        this.percAvanco = 0.0;
        this.ativo = 1;
        this.utilizarCotVenda = 0;
        this.utilizarPreCotVenda = 0;
    }

    @Id
    @Column(name="ID_SITUACAO_COTACAO_VENDAS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_SITUACAO_COTACAO_VENDAS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="DESCRICAO", length=120)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="TIPO_COTACAO")
    public Short getTipoCotacao() {
        return this.tipoCotacao;
    }

    public void setTipoCotacao(Short tipoCotacao) {
        this.tipoCotacao = tipoCotacao;
    }

    @Column(name="PERC_AVANCO", precision=15, scale=2)
    public Double getPercAvanco() {
        return this.percAvanco;
    }

    public void setPercAvanco(Double percAvanco) {
        this.percAvanco = percAvanco;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Column(name="UTILIZAR_COT_VENDA")
    public Short getUtilizarCotVenda() {
        return this.utilizarCotVenda;
    }

    public void setUtilizarCotVenda(Short utilizarCotVenda) {
        this.utilizarCotVenda = utilizarCotVenda;
    }

    @Column(name="UTILIZAR_PRE_COT_VENDA")
    public Short getUtilizarPreCotVenda() {
        return this.utilizarPreCotVenda;
    }

    public void setUtilizarPreCotVenda(Short utilizarPreCotVenda) {
        this.utilizarPreCotVenda = utilizarPreCotVenda;
    }
}

