/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoDeSituacoesGrupo;
import com.touchcomp.basementor.model.vo.ModeloEmail;
import com.touchcomp.basementor.model.vo.SituacaoPedidosGrupo;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="SITUACAO_PEDIDOS", uniqueConstraints={@UniqueConstraint(name="UNQ1_SITUACAO_PEDIDOS", columnNames={"DESCRICAO"})})
public class SituacaoPedidos
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private String descricao;
    private String descricaoAuxiliar;
    private List<SituacaoPedidosGrupo> grupoUsuarios = new ArrayList<SituacaoPedidosGrupo>();
    private Short email = EnumConstantsMentorSimNao.NAO.getValue();
    private ModeloEmail modeloEmail;
    private Short inserirObservacao = EnumConstantsMentorSimNao.NAO.getValue();
    private Short enviarXML = EnumConstantsMentorSimNao.NAO.getValue();
    private Short enviarDANFE = EnumConstantsMentorSimNao.NAO.getValue();
    private Short enviarSomenteNfAprovada = EnumConstantsMentorSimNao.NAO.getValue();
    private Short cancelarTitulos = EnumConstantsMentorSimNao.NAO.getValue();
    private Short nrOrdem = EnumConstantsMentorSimNao.NAO.getValue();
    private List<GrupoDeSituacoesGrupo> grupoDeSituacoes = new ArrayList<GrupoDeSituacoesGrupo>();
    private Short bloqueioPedidoPorSituacao = EnumConstantsMentorSimNao.NAO.getValue();
    private Short bloqueioExclusaoPedidoPorSituacao;
    private Short bloqueioExpedicaoPorSituacao = EnumConstantsMentorSimNao.NAO.getValue();
    private Short bloqueioAltExcPedidoOtimizado;
    private Short gerarFinanceiroNFCe = EnumConstantsMentorSimNao.NAO.getValue();
    private Short disponivelNFCe = EnumConstantsMentorSimNao.NAO.getValue();
    private Short bloqueioReservaEstoque = EnumConstantsMentorSimNao.NAO.getValue();
    private Double horasSituacao = 0.0;
    private Short naoUtilizarExpedicao;
    private Short naoGerarTitulosPedido;

    public SituacaoPedidos() {
        this.bloqueioExclusaoPedidoPorSituacao = EnumConstantsMentorSimNao.NAO.getValue();
        this.bloqueioAltExcPedidoOtimizado = EnumConstantsMentorSimNao.NAO.getValue();
        this.naoUtilizarExpedicao = EnumConstantsMentorSimNao.NAO.getValue();
        this.naoGerarTitulosPedido = EnumConstantsMentorSimNao.NAO.getValue();
    }

    @Id
    @Column(name="ID_SITUACAO_PEDIDOS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_SITUACAO_PEDIDOS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_SITUACAO_PEDIDOS_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="DESCRICAO", length=100)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @OneToMany(mappedBy="situacaoPedidos", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<SituacaoPedidosGrupo> getGrupoUsuarios() {
        return this.grupoUsuarios;
    }

    public void setGrupoUsuarios(List<SituacaoPedidosGrupo> grupoUsuarios) {
        this.grupoUsuarios = grupoUsuarios;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="EMAIL")
    public Short getEmail() {
        return this.email;
    }

    public void setEmail(Short email) {
        this.email = email;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MODELO_EMAIL", foreignKey=@ForeignKey(name="FK_SITUACAO_PEDIDOS_MOD_EMAIL"))
    public ModeloEmail getModeloEmail() {
        return this.modeloEmail;
    }

    public void setModeloEmail(ModeloEmail modeloEmail) {
        this.modeloEmail = modeloEmail;
    }

    @Column(name="INSERIR_OBSERVACAO")
    public Short getInserirObservacao() {
        return this.inserirObservacao;
    }

    public void setInserirObservacao(Short inserirObservacao) {
        this.inserirObservacao = inserirObservacao;
    }

    @Column(name="ENVIAR_DANFE")
    public Short getEnviarDANFE() {
        return this.enviarDANFE;
    }

    public void setEnviarDANFE(Short enviarDANFE) {
        this.enviarDANFE = enviarDANFE;
    }

    @Column(name="ENVIAR_XML")
    public Short getEnviarXML() {
        return this.enviarXML;
    }

    public void setEnviarXML(Short enviarXML) {
        this.enviarXML = enviarXML;
    }

    @Column(name="ENVIAR_SOMENTE_NF_APROV")
    public Short getEnviarSomenteNfAprovada() {
        return this.enviarSomenteNfAprovada;
    }

    public void setEnviarSomenteNfAprovada(Short enviarSomenteNfAprovada) {
        this.enviarSomenteNfAprovada = enviarSomenteNfAprovada;
    }

    @Column(updatable=false, name="CANCELAR_TITULOS")
    public Short getCancelarTitulos() {
        return this.cancelarTitulos;
    }

    public void setCancelarTitulos(Short cancelarTitulos) {
        this.cancelarTitulos = cancelarTitulos;
    }

    @Column(name="NR_ORDEM")
    public Short getNrOrdem() {
        return this.nrOrdem;
    }

    public void setNrOrdem(Short nrOrdem) {
        this.nrOrdem = nrOrdem;
    }

    @OneToMany(mappedBy="situacaoPedidos")
    public List<GrupoDeSituacoesGrupo> getGrupoDeSituacoes() {
        return this.grupoDeSituacoes;
    }

    public void setGrupoDeSituacoes(List<GrupoDeSituacoesGrupo> grupoDeSituacoes) {
        this.grupoDeSituacoes = grupoDeSituacoes;
    }

    @Column(name="BLOQUEIO_PEDIDO_SITUACAO")
    public Short getBloqueioPedidoPorSituacao() {
        return this.bloqueioPedidoPorSituacao;
    }

    public void setBloqueioPedidoPorSituacao(Short bloqueioPedidoPorSituacao) {
        this.bloqueioPedidoPorSituacao = bloqueioPedidoPorSituacao;
    }

    @Column(name="BLOQUEIO_EXCLUSAO_PED_SITUACAO")
    public Short getBloqueioExclusaoPedidoPorSituacao() {
        return this.bloqueioExclusaoPedidoPorSituacao;
    }

    public void setBloqueioExclusaoPedidoPorSituacao(Short bloqueioExcluirPedidoPorSituacao) {
        this.bloqueioExclusaoPedidoPorSituacao = bloqueioExcluirPedidoPorSituacao;
    }

    @Column(name="BLOQUEIO_EXPEDICAO_SITUACAO")
    public Short getBloqueioExpedicaoPorSituacao() {
        return this.bloqueioExpedicaoPorSituacao;
    }

    public void setBloqueioExpedicaoPorSituacao(Short bloqueioExpedicaoPorSituacao) {
        this.bloqueioExpedicaoPorSituacao = bloqueioExpedicaoPorSituacao;
    }

    @Column(name="GERAR_FINANCEIRO_NFCE")
    public Short getGerarFinanceiroNFCe() {
        return this.gerarFinanceiroNFCe;
    }

    public void setGerarFinanceiroNFCe(Short gerarFinanceiroNFCe) {
        this.gerarFinanceiroNFCe = gerarFinanceiroNFCe;
    }

    @Column(name="DISPONIVEL_NFCE")
    public Short getDisponivelNFCe() {
        return this.disponivelNFCe;
    }

    public void setDisponivelNFCe(Short disponivelNFCe) {
        this.disponivelNFCe = disponivelNFCe;
    }

    @Column(name="BLOQUEIO_RESERVA_ESTOQUE")
    public Short getBloqueioReservaEstoque() {
        return this.bloqueioReservaEstoque;
    }

    public void setBloqueioReservaEstoque(Short bloqueioReservaEstoque) {
        this.bloqueioReservaEstoque = bloqueioReservaEstoque;
    }

    @Column(name="HORAS_SITUACAO")
    public Double getHorasSituacao() {
        return this.horasSituacao;
    }

    public void setHorasSituacao(Double horasSituacao) {
        this.horasSituacao = horasSituacao;
    }

    @Column(name="bloqueio_alt_exc_ped_otimizado")
    public Short getBloqueioAltExcPedidoOtimizado() {
        return this.bloqueioAltExcPedidoOtimizado;
    }

    public void setBloqueioAltExcPedidoOtimizado(Short bloqueioAltExcPedidoOtimizado) {
        this.bloqueioAltExcPedidoOtimizado = bloqueioAltExcPedidoOtimizado;
    }

    @Column(name="DESCRICAO_AUXILIAR")
    public String getDescricaoAuxiliar() {
        return this.descricaoAuxiliar;
    }

    public void setDescricaoAuxiliar(String descricaoAuxiliar) {
        this.descricaoAuxiliar = descricaoAuxiliar;
    }

    @Column(name="NAO_UTILIZAR_EXPEDICAO")
    public Short getNaoUtilizarExpedicao() {
        return this.naoUtilizarExpedicao;
    }

    public void setNaoUtilizarExpedicao(Short naoUtilizarExpedicao) {
        this.naoUtilizarExpedicao = naoUtilizarExpedicao;
    }

    @Column(name="NAO_GERAR_TITULOS_PEDIDO")
    public Short getNaoGerarTitulosPedido() {
        return this.naoGerarTitulosPedido;
    }

    public void setNaoGerarTitulosPedido(Short naoGerarTitulosPedido) {
        this.naoGerarTitulosPedido = naoGerarTitulosPedido;
    }
}

