/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.LocalizacaoAtivo;
import com.touchcomp.basementor.model.vo.SolicitacaoAnterior;
import com.touchcomp.basementor.model.vo.TipoServico;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="SOLICITACAO_SERVICO")
public class SolicitacaoServico
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Short status = 0;
    private Short prioridade = 0;
    private String descricao;
    private Timestamp dataHoraParada;
    private TipoServico tipoServico;
    private LocalizacaoAtivo localizacaoAtivo;
    private Equipamento ativo;
    private Usuario usuario;
    private SolicitacaoAnterior solicitacaoAnterior;
    private Short ativoParado = 1;

    @Id
    @Column(nullable=false, name="ID_SOLICITACAO_SERVICO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_SOLICITACAO_SERVICO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_SOLICITACAO_SERVICO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="STATUS")
    public Short getStatus() {
        return this.status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    @Column(name="PRIORIDADE")
    public Short getPrioridade() {
        return this.prioridade;
    }

    public void setPrioridade(Short prioridade) {
        this.prioridade = prioridade;
    }

    @Column(name="DESCRICAO", length=500)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="DATA_HORA_PARADA")
    public Timestamp getDataHoraParada() {
        return this.dataHoraParada;
    }

    public void setDataHoraParada(Timestamp dataHoraParada) {
        this.dataHoraParada = dataHoraParada;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_SERVICO", foreignKey=@ForeignKey(name="FK_SOLICITACAO_SERVICO_TP_SERVI"))
    public TipoServico getTipoServico() {
        return this.tipoServico;
    }

    public void setTipoServico(TipoServico tipoServico) {
        this.tipoServico = tipoServico;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOCALIZACAO_ATIVO", foreignKey=@ForeignKey(name="FK_SOLICITACAO_SERVICO_LOC_ATIV"))
    public LocalizacaoAtivo getLocalizacaoAtivo() {
        return this.localizacaoAtivo;
    }

    public void setLocalizacaoAtivo(LocalizacaoAtivo localizacaoAtivo) {
        this.localizacaoAtivo = localizacaoAtivo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ATIVO", foreignKey=@ForeignKey(name="FK_SOLICITACAO_SERVICO_ATIVO"))
    public Equipamento getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Equipamento ativo) {
        this.ativo = ativo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_SOLICITACAO_SERVICO_USUARIO"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SOLICITACAO_ANTERIOR", foreignKey=@ForeignKey(name="FK_SOLICITACAO_SERVICO_SOL_ANT"))
    @Cascade(value={CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    public SolicitacaoAnterior getSolicitacaoAnterior() {
        return this.solicitacaoAnterior;
    }

    public void setSolicitacaoAnterior(SolicitacaoAnterior solicitacaoAnterior) {
        this.solicitacaoAnterior = solicitacaoAnterior;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="ATIVO_PARADO")
    public Short getAtivoParado() {
        return this.ativoParado;
    }

    public void setAtivoParado(Short ativoParado) {
        this.ativoParado = ativoParado;
    }
}

