/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Especie;
import com.touchcomp.basementor.model.vo.GrupoSubespecieRelSub;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="SUB_ESPECIE", uniqueConstraints={@UniqueConstraint(name="UNQ1_SUB_ESPECIE", columnNames={"ID_ESPECIE", "NOME"})})
public class SubEspecie
implements InterfaceVO {
    private Long identificador;
    private Especie especie;
    private String nome;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private String codSincronizacao;
    private List<GrupoSubespecieRelSub> grupoSubespeciesRel;

    public SubEspecie() {
        this.grupoSubespeciesRel = new ArrayList<GrupoSubespecieRelSub>();
    }

    public SubEspecie(Long idSub, String especieNome, String nome, Long idEspecie) {
        this.identificador = idSub;
        this.especie = new Especie();
        this.especie.setNome(especieNome);
        this.nome = nome;
        this.especie.setIdentificador(idEspecie);
    }

    @Id
    @Column(nullable=false, name="ID_SUB_ESPECIE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_SUB_ESPECIE")
    public Long getIdentificador() {
        return this.identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_ESPECIE", foreignKey=@ForeignKey(name="FK_SUB_ESPECIE_ESPECIE"))
    public Especie getEspecie() {
        return this.especie;
    }

    @Column(unique=true, nullable=false, name="NOME", length=40)
    public String getNome() {
        return this.nome;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_SUB_ESPECIE_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setEspecie(Especie especie) {
        this.especie = especie;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getNome()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @OneToMany(mappedBy="subespecie")
    public List<GrupoSubespecieRelSub> getGrupoSubespeciesRel() {
        return this.grupoSubespeciesRel;
    }

    public void setGrupoSubespeciesRel(List<GrupoSubespecieRelSub> grupoSubespeciesRel) {
        this.grupoSubespeciesRel = grupoSubespeciesRel;
    }

    @Column(name="COD_SINCRONIZACAO", length=30)
    public String getCodSincronizacao() {
        return this.codSincronizacao;
    }

    public void setCodSincronizacao(String codSincronizacao) {
        this.codSincronizacao = codSincronizacao;
    }
}

