/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.FeriasColaborador;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="SUSPENSAO_FERIAS")
public class SuspensaoFerias
implements InterfaceVO,
InterfaceVOEsocial {
    private Long identificador;
    private Timestamp dataAtualizacao;
    private Date dataCadastro;
    private Empresa empresa;
    private FeriasColaborador ferias;
    private Date dataSuspensao;
    private Date dataFimSuspensao;
    private String motivo;
    private List<EsocPreEvento> preEventosEsocial = new ArrayList<EsocPreEvento>();
    private Long diasRestanteFerias = 0L;

    @Id
    @Column(nullable=false, unique=true, name="ID_SUSPENSAO_FERIAS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_SUSPENSAO_FERIAS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_EMPRESA_SUSPENSAO_FERIAS"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FERIAS", foreignKey=@ForeignKey(name="FK_FERIAS_SUSPENSAO_FERIAS"))
    @Cascade(value={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.SAVE_UPDATE})
    public FeriasColaborador getFerias() {
        return this.ferias;
    }

    public void setFerias(FeriasColaborador ferias) {
        this.ferias = ferias;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_SUSPENSAO")
    public Date getDataSuspensao() {
        return this.dataSuspensao;
    }

    public void setDataSuspensao(Date dataSuspensao) {
        this.dataSuspensao = dataSuspensao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FIM_SUSPENSAO")
    public Date getDataFimSuspensao() {
        return this.dataFimSuspensao;
    }

    public void setDataFimSuspensao(Date dataFimSuspensao) {
        this.dataFimSuspensao = dataFimSuspensao;
    }

    @Column(name="MOTIVO", length=300)
    public String getMotivo() {
        return this.motivo;
    }

    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Override
    @OneToMany(mappedBy="suspensaoFerias")
    public List<EsocPreEvento> getPreEventosEsocial() {
        return this.preEventosEsocial;
    }

    public void setPreEventosEsocial(List<EsocPreEvento> preEventosEsocial) {
        this.preEventosEsocial = preEventosEsocial;
    }

    @Column(name="DIAS_RESTANTES_FERIAS")
    public Long getDiasRestanteFerias() {
        return this.diasRestanteFerias;
    }

    public void setDiasRestanteFerias(Long diasRestanteFerias) {
        this.diasRestanteFerias = diasRestanteFerias;
    }
}

