/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ConvenioPlanoSaude;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemTabelaPlanoSaude;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="TABELA_PLANO_SAUDE")
public class TabelaAtualizacaoPlanoSaude
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Date dataInicialVigencia;
    private Date dataFinalVigencia;
    private TipoCalculoEvento tipoCalculoEvento;
    private ConvenioPlanoSaude convenioPlanoSaude;
    private List<ItemTabelaPlanoSaude> itemTabelaPlanoSaude = new ArrayList<ItemTabelaPlanoSaude>();

    @Id
    @Column(name="ID_TABELA_PLANO_SAUDE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_TABELA_PLANO_SAUDE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_TABELA_PLANO_SAUDE_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_INICIAL_VIGENCIA")
    public Date getDataInicialVigencia() {
        return this.dataInicialVigencia;
    }

    public void setDataInicialVigencia(Date dataInicialVigencia) {
        this.dataInicialVigencia = dataInicialVigencia;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FINAL_VIGENCIA")
    public Date getDataFinalVigencia() {
        return this.dataFinalVigencia;
    }

    public void setDataFinalVigencia(Date dataFinalVigencia) {
        this.dataFinalVigencia = dataFinalVigencia;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_CALCULO_EVENTO", foreignKey=@ForeignKey(name="FK_TABELA_PLANO_SAUDE_TIPO_CALC"))
    public TipoCalculoEvento getTipoCalculoEvento() {
        return this.tipoCalculoEvento;
    }

    public void setTipoCalculoEvento(TipoCalculoEvento tipoCalculoEvento) {
        this.tipoCalculoEvento = tipoCalculoEvento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONVENIO_PLANO_SAUDE", foreignKey=@ForeignKey(name="FK_TABELA_PLANO_SAUDE_CONV_PL_S"))
    public ConvenioPlanoSaude getConvenioPlanoSaude() {
        return this.convenioPlanoSaude;
    }

    public void setConvenioPlanoSaude(ConvenioPlanoSaude convenioPlanoSaude) {
        this.convenioPlanoSaude = convenioPlanoSaude;
    }

    @OneToMany(mappedBy="tabelaAtualizacaoPlanoSaude", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ItemTabelaPlanoSaude> getItemTabelaPlanoSaude() {
        return this.itemTabelaPlanoSaude;
    }

    public void setItemTabelaPlanoSaude(List<ItemTabelaPlanoSaude> itemTabelaPlanoSaude) {
        this.itemTabelaPlanoSaude = itemTabelaPlanoSaude;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

