/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CalculoFrete;
import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.FormulaCalculoFrete;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="TABELA_CALCULO_FRETE")
public class TabelaCalculoFrete
implements InterfaceVO {
    private Long identificador;
    private CalculoFrete calculoFrete;
    private String descricao;
    private List<Cidade> cidades = new ArrayList<Cidade>();
    private List<Cidade> cidadesDestino = new ArrayList<Cidade>();
    private List<FormulaCalculoFrete> formulas = new ArrayList<FormulaCalculoFrete>();
    private List<Cliente> cliente = new ArrayList<Cliente>();

    @OneToMany(targetEntity=Cidade.class, fetch=FetchType.LAZY)
    @JoinTable(name="calculo_frete_cidades", joinColumns={@JoinColumn(name="ID_TABELA_CALCULO_FRETE")}, inverseJoinColumns={@JoinColumn(name="id_cidade")})
    public List<Cidade> getCidades() {
        return this.cidades;
    }

    public void setCidades(List<Cidade> cidades) {
        this.cidades = cidades;
    }

    @OneToMany(mappedBy="tabelaCalculoFrete", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<FormulaCalculoFrete> getFormulas() {
        return this.formulas;
    }

    public void setFormulas(List<FormulaCalculoFrete> formulas) {
        this.formulas = formulas;
    }

    @Id
    @Column(name="ID_TABELA_CALCULO_FRETE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_TABELA_CALCULO_FRETE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CALCULO_FRETE", foreignKey=@ForeignKey(name="FK_CALCULO_FRETE"))
    public CalculoFrete getCalculoFrete() {
        return this.calculoFrete;
    }

    public void setCalculoFrete(CalculoFrete calculoFrete) {
        this.calculoFrete = calculoFrete;
    }

    @Column(name="DESCRICAO", length=500)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @OneToMany(targetEntity=Cliente.class, fetch=FetchType.LAZY)
    @JoinTable(name="CALCULO_FRETE_CLIENTES", joinColumns={@JoinColumn(name="ID_TABELA_CALCULO_FRETE")}, inverseJoinColumns={@JoinColumn(name="ID_CLIENTE")})
    public List<Cliente> getCliente() {
        return this.cliente;
    }

    public void setCliente(List<Cliente> cliente) {
        this.cliente = cliente;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"C?lc. Frete: {0} / Tab. Frete: {1} - {2}", (Object[])new Object[]{this.getCalculoFrete() != null ? this.getCalculoFrete().getIdentificador() : "", this.getIdentificador(), this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(targetEntity=Cidade.class, fetch=FetchType.LAZY)
    @JoinTable(name="calculo_frete_cidades_dest", joinColumns={@JoinColumn(name="ID_TABELA_CALCULO_FRETE")}, inverseJoinColumns={@JoinColumn(name="id_cidade")})
    public List<Cidade> getCidadesDestino() {
        return this.cidadesDestino;
    }

    public void setCidadesDestino(List<Cidade> cidadesDestino) {
        this.cidadesDestino = cidadesDestino;
    }
}

