/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Moeda;
import com.touchcomp.basementor.model.vo.TabelaPrecoBaseGrupoProdutos;
import com.touchcomp.basementor.model.vo.TabelaPrecoBasePadAnaPr;
import com.touchcomp.basementor.model.vo.TabelaPrecoBaseProduto;
import com.touchcomp.basementor.model.vo.TabelaPrecoBaseUF;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="TABELA_PRECO_BASE")
public class TabelaPrecoBase
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private Date dataInicial;
    private Date dataFinal;
    private String descricao;
    private Double percValorMin = 0.0;
    private Double percValorMax = 0.0;
    private Double percComissaoMin = 0.0;
    private Double percComissaoMax = 0.0;
    private Double percComissaoPad = 0.0;
    private Double margemLucro = 0.0;
    private Short nrCasasDec = 0;
    private Short tabelaUsoInterno = 0;
    private Timestamp dataAtualizacao;
    private List<TabelaPrecoBaseProduto> produtos = new ArrayList<TabelaPrecoBaseProduto>();
    private Integer tabelaPrincipal = 0;
    private List<TabelaPrecoBaseUF> ufs = new ArrayList<TabelaPrecoBaseUF>();
    private List<TabelaPrecoBaseGrupoProdutos> grupoProdutos = new ArrayList<TabelaPrecoBaseGrupoProdutos>();
    private List<TabelaPrecoBasePadAnaPr> padroesAnaPreco = new ArrayList<TabelaPrecoBasePadAnaPr>();
    private Moeda moeda;
    private Double toleranciaPrecoAbaixo = 0.0;
    private Double toleranciaPrecoAcima = 0.0;
    private TabelaPrecoBase tabelaPrecoVinculada;

    @Id
    @Column(name="ID_TABELA_PRECO_BASE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_TABELA_PRECO_BASE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_TABELA_PRECO_BASE_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_INICIAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Column(name="DATA_FINAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Column(name="DESCRICAO", length=60)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @OneToMany(mappedBy="tabelaPrecoBase", orphanRemoval=true, cascade={CascadeType.ALL})
    public List<TabelaPrecoBaseProduto> getProdutos() {
        return this.produtos;
    }

    public void setProdutos(List<TabelaPrecoBaseProduto> produtos) {
        this.produtos = produtos;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(nullable=false, name="PERC_VALOR_MIN", precision=3, scale=2)
    public Double getPercValorMin() {
        return this.percValorMin;
    }

    public void setPercValorMin(Double percValorMin) {
        this.percValorMin = percValorMin;
    }

    @Column(nullable=false, name="PERC_VALOR_MAX", precision=3, scale=2)
    public Double getPercValorMax() {
        return this.percValorMax;
    }

    public void setPercValorMax(Double percValorMax) {
        this.percValorMax = percValorMax;
    }

    @Column(name="TABELA_PRINCIPAL")
    public Integer getTabelaPrincipal() {
        return this.tabelaPrincipal;
    }

    public void setTabelaPrincipal(Integer tabelaPrincipal) {
        this.tabelaPrincipal = tabelaPrincipal;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="tabelaPrecoBase", orphanRemoval=true, cascade={CascadeType.ALL})
    public List<TabelaPrecoBaseUF> getUfs() {
        return this.ufs;
    }

    public void setUfs(List<TabelaPrecoBaseUF> ufs) {
        this.ufs = ufs;
    }

    @OneToMany(mappedBy="tabelaPrecoBase", orphanRemoval=true, cascade={CascadeType.ALL})
    public List<TabelaPrecoBaseGrupoProdutos> getGrupoProdutos() {
        return this.grupoProdutos;
    }

    public void setGrupoProdutos(List<TabelaPrecoBaseGrupoProdutos> grupoProdutos) {
        this.grupoProdutos = grupoProdutos;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MOEDA", foreignKey=@ForeignKey(name="FK_TABELA_PRECO_BASE_MOEDA"))
    public Moeda getMoeda() {
        return this.moeda;
    }

    public void setMoeda(Moeda moeda) {
        this.moeda = moeda;
    }

    @OneToMany(mappedBy="tabelaPrecoBase", orphanRemoval=true, cascade={CascadeType.ALL})
    public List<TabelaPrecoBasePadAnaPr> getPadroesAnaPreco() {
        return this.padroesAnaPreco;
    }

    public void setPadroesAnaPreco(List<TabelaPrecoBasePadAnaPr> padroesAnaPreco) {
        this.padroesAnaPreco = padroesAnaPreco;
    }

    @Column(nullable=false, name="PERC_COMISSAO_MIN", precision=15, scale=2)
    public Double getPercComissaoMin() {
        return this.percComissaoMin;
    }

    public void setPercComissaoMin(Double percComissaoMin) {
        this.percComissaoMin = percComissaoMin;
    }

    @Column(nullable=false, name="PERC_COMISSAO_MAX", precision=15, scale=2)
    public Double getPercComissaoMax() {
        return this.percComissaoMax;
    }

    public void setPercComissaoMax(Double percComissaoMax) {
        this.percComissaoMax = percComissaoMax;
    }

    @Column(nullable=false, name="PERC_COMISSAO_PAD", precision=15, scale=2)
    public Double getPercComissaoPad() {
        return this.percComissaoPad;
    }

    public void setPercComissaoPad(Double percComissaoPad) {
        this.percComissaoPad = percComissaoPad;
    }

    @Column(nullable=false, name="MARGEM_LUCRO", precision=15, scale=2)
    public Double getMargemLucro() {
        return this.margemLucro;
    }

    public void setMargemLucro(Double margemLucro) {
        this.margemLucro = margemLucro;
    }

    @Column(nullable=false, name="NR_CASAS_DECIMAIS")
    public Short getNrCasasDec() {
        return this.nrCasasDec;
    }

    public void setNrCasasDec(Short nrCasasDec) {
        this.nrCasasDec = nrCasasDec;
    }

    @Column(nullable=false, name="TOLERANCIA_PRECO_ABAIXO", precision=15, scale=2)
    public Double getToleranciaPrecoAbaixo() {
        return this.toleranciaPrecoAbaixo;
    }

    public void setToleranciaPrecoAbaixo(Double toleranciaPrecoAbaixo) {
        this.toleranciaPrecoAbaixo = toleranciaPrecoAbaixo;
    }

    @Column(nullable=false, name="TOLERANCIA_PRECO_ACIMA", precision=15, scale=2)
    public Double getToleranciaPrecoAcima() {
        return this.toleranciaPrecoAcima;
    }

    public void setToleranciaPrecoAcima(Double toleranciaPrecoAcima) {
        this.toleranciaPrecoAcima = toleranciaPrecoAcima;
    }

    @Column(name="TABELA_USO_INTERNO")
    public Short getTabelaUsoInterno() {
        return this.tabelaUsoInterno;
    }

    public void setTabelaUsoInterno(Short tabelaUsoInterno) {
        this.tabelaUsoInterno = tabelaUsoInterno;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TABELA_PRECO_VINCULADA", foreignKey=@ForeignKey(name="FK_TABELA_PRECO_BASE_TB_VINCULA"))
    public TabelaPrecoBase getTabelaPrecoVinculada() {
        return this.tabelaPrecoVinculada;
    }

    public void setTabelaPrecoVinculada(TabelaPrecoBase tabelaPrecoVinculada) {
        this.tabelaPrecoVinculada = tabelaPrecoVinculada;
    }
}

