/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProd;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.TabelaPrecoBase;
import com.touchcomp.basementor.model.vo.TabelaPrecoBaseProdutoComissao;
import com.touchcomp.basementor.model.vo.TipoItemTabPrecoProd;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="TABELA_PRECO_BASE_PROD")
public class TabelaPrecoBaseProduto
implements InterfaceVO {
    private Long identificador;
    private Produto produto;
    private Double valorVenda = 0.0;
    private Double valorCusto = 0.0;
    private Double percMinimo = 0.0;
    private Double percMaximo = 0.0;
    private Double percComissaoPadrao = 0.0;
    private Double margemLucro = 0.0;
    private TabelaPrecoBase tabelaPrecoBase;
    private Timestamp dataAtualizacao;
    private Short ativo;
    private List<TabelaPrecoBaseProdutoComissao> comissoes;
    private Double percMinimoComissao = 0.0;
    private Double percMaximoComissao = 0.0;
    private Double valorMinimo;
    private Double valorMaximo;
    private AnalisePrVendaProd analisePrecoVendaProd;
    private Double valorVendaAnterior;
    private Date dataValidade;
    private Date dataUltCompra;
    private Date dataCriacao;
    private Double valorCustoAnterior = 0.0;
    private Double percentualDescTrib;
    private TipoItemTabPrecoProd tipoItemTabPreco;
    private Timestamp dataModificacao;

    public TabelaPrecoBaseProduto() {
        this.setValorMinimo(0.0);
        this.setValorMaximo(0.0);
        this.ativo = 1;
        this.dataCriacao = new Date();
        this.comissoes = new ArrayList<TabelaPrecoBaseProdutoComissao>();
        this.valorMinimo = 0.0;
        this.valorMaximo = 0.0;
        this.valorVendaAnterior = 0.0;
        this.percentualDescTrib = 0.0;
    }

    @Id
    @Column(name="ID_TABELA_PRECO_BASE_PROD")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_TABELA_PRECO_BASE_PROD")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRODUTO", foreignKey=@ForeignKey(name="FK_TABELA_PRECO_BASE_PROD_PROD"))
    public Produto getProduto() {
        return this.produto;
    }

    public void setProduto(Produto produto) {
        this.produto = produto;
    }

    @Column(name="VALOR_VENDA", precision=15, scale=6)
    public Double getValorVenda() {
        return this.valorVenda;
    }

    public void setValorVenda(Double valorVenda) {
        this.valorVenda = valorVenda;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TABELA_PRECO_BASE", foreignKey=@ForeignKey(name="FK_TABELA_PRECO_BASE_PROD_BASE"))
    public TabelaPrecoBase getTabelaPrecoBase() {
        return this.tabelaPrecoBase;
    }

    public void setTabelaPrecoBase(TabelaPrecoBase tabelaPrecoBase) {
        this.tabelaPrecoBase = tabelaPrecoBase;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getTabelaPrecoBase() != null ? this.getTabelaPrecoBase() : "", this.getProduto()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(nullable=false, name="VALOR_CUSTO", precision=15, scale=6)
    public Double getValorCusto() {
        return this.valorCusto;
    }

    public void setValorCusto(Double valorCusto) {
        this.valorCusto = valorCusto;
    }

    @Column(name="PERC_MINIMO", precision=15, scale=2)
    public Double getPercMinimo() {
        return this.percMinimo;
    }

    public void setPercMinimo(Double percMinimo) {
        this.percMinimo = percMinimo;
    }

    @Column(name="PERC_MAXIMO", precision=15, scale=2)
    public Double getPercMaximo() {
        return this.percMaximo;
    }

    public void setPercMaximo(Double percMaximo) {
        this.percMaximo = percMaximo;
    }

    @Column(name="MARGEM_LUCRO", precision=15, scale=6)
    public Double getMargemLucro() {
        return this.margemLucro;
    }

    public void setMargemLucro(Double margemLucro) {
        this.margemLucro = margemLucro;
    }

    @Column(name="PERC_COMISSAO_PADRAO", precision=15, scale=6)
    public Double getPercComissaoPadrao() {
        return this.percComissaoPadrao;
    }

    public void setPercComissaoPadrao(Double percComissaoPadrao) {
        this.percComissaoPadrao = percComissaoPadrao;
    }

    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @OneToMany(mappedBy="tabelaPrecoBaseProduto", orphanRemoval=true, cascade={CascadeType.ALL})
    public List<TabelaPrecoBaseProdutoComissao> getComissoes() {
        return this.comissoes;
    }

    public void setComissoes(List<TabelaPrecoBaseProdutoComissao> comissoes) {
        this.comissoes = comissoes;
    }

    @Column(nullable=false, name="PERC_MINIMO_COMISSAO", precision=15, scale=6)
    public Double getPercMinimoComissao() {
        return this.percMinimoComissao;
    }

    public void setPercMinimoComissao(Double percMinimoComissao) {
        this.percMinimoComissao = percMinimoComissao;
    }

    @Column(nullable=false, name="PERC_MAXIMO_COMISSAO", precision=15, scale=6)
    public Double getPercMaximoComissao() {
        return this.percMaximoComissao;
    }

    public void setPercMaximoComissao(Double percMaximoComissao) {
        this.percMaximoComissao = percMaximoComissao;
    }

    @Column(name="VALOR_MINIMO", precision=15, scale=6)
    public Double getValorMinimo() {
        return this.valorMinimo;
    }

    public void setValorMinimo(Double valorMinimo) {
        this.valorMinimo = valorMinimo;
    }

    @Column(nullable=false, name="VALOR_MAXIMO", precision=15, scale=6)
    public Double getValorMaximo() {
        return this.valorMaximo;
    }

    public void setValorMaximo(Double valorMaximo) {
        this.valorMaximo = valorMaximo;
    }

    @OneToOne(mappedBy="tabelaPrecoBaseProduto")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public AnalisePrVendaProd getAnalisePrecoVendaProd() {
        return this.analisePrecoVendaProd;
    }

    public void setAnalisePrecoVendaProd(AnalisePrVendaProd analisePrecoVendaProd) {
        this.analisePrecoVendaProd = analisePrecoVendaProd;
    }

    @Column(name="VALOR_VENDA_ANTERIOR", precision=15, scale=6)
    public Double getValorVendaAnterior() {
        return this.valorVendaAnterior;
    }

    public void setValorVendaAnterior(Double valorVendaAnterior) {
        this.valorVendaAnterior = valorVendaAnterior;
    }

    @Column(name="DATA_VALIDADE")
    @Temporal(value=TemporalType.DATE)
    public Date getDataValidade() {
        return this.dataValidade;
    }

    public void setDataValidade(Date dataValidade) {
        this.dataValidade = dataValidade;
    }

    @Column(name="DATA_ULT_COMPRA")
    @Temporal(value=TemporalType.DATE)
    public Date getDataUltCompra() {
        return this.dataUltCompra;
    }

    public void setDataUltCompra(Date dataUltCompra) {
        this.dataUltCompra = dataUltCompra;
    }

    @Column(name="VALOR_CUSTO_ANTERIOR", precision=15, scale=6)
    public Double getValorCustoAnterior() {
        return this.valorCustoAnterior;
    }

    public void setValorCustoAnterior(Double valorCustoAnterior) {
        this.valorCustoAnterior = valorCustoAnterior;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_ITEM_TAB_PRECO_PROD", foreignKey=@ForeignKey(name="FK_TABELA_PRECO_BASE_PROD_TP_IT"))
    public TipoItemTabPrecoProd getTipoItemTabPreco() {
        return this.tipoItemTabPreco;
    }

    public void setTipoItemTabPreco(TipoItemTabPrecoProd tipoItemTabPreco) {
        this.tipoItemTabPreco = tipoItemTabPreco;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_CRIACAO")
    public Date getDataCriacao() {
        return this.dataCriacao;
    }

    public void setDataCriacao(Date dataCriacao) {
        this.dataCriacao = dataCriacao;
    }

    @Column(name="PERCENTUAL_DESC_TRIB", precision=4, scale=14)
    public Double getPercentualDescTrib() {
        return this.percentualDescTrib;
    }

    public void setPercentualDescTrib(Double percentualDescTrib) {
        this.percentualDescTrib = percentualDescTrib;
    }

    @Version
    @Column(name="DATA_MODIFICACAO")
    public Timestamp getDataModificacao() {
        return this.dataModificacao;
    }

    public void setDataModificacao(Timestamp dataModificacao) {
        this.dataModificacao = dataModificacao;
    }
}

