/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.receitaagronomica.EnumConstProvedorRecAgro;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificado;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.TecnicoAgricolaCREA;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="TECNICO_AGRICOLA")
public class TecnicoAgricola
implements InterfaceVO {
    private Long identificador;
    private Pessoa pessoa;
    private String crea;
    private String titulo;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private String codSincronizacao;
    private String codSincronizacao2;
    private Short codProvServicoRec = EnumConstProvedorRecAgro.SEM_VINCULO_SERVICO.getValue();
    private Date dataAtualizacaoSisTerc;
    private Long artPrimaria = 0L;
    private Long artSecundaria = 0L;
    private Integer nrCopias = 1;
    private Long nrUltimaReceita = 1L;
    private Integer formatoReceita = 1;
    private Short buscarArt = 1;
    private Long nrReceitasArt = 1L;
    private Long nrReceitasMes = 1L;
    private String login;
    private String senha;
    private List<TecnicoAgricolaCREA> tecnicoAgrCrea = new LinkedList<TecnicoAgricolaCREA>();
    private ConfiguracaoCertificado configuracaoCertificado;
    private Short ativo = 1;

    @Id
    @Column(nullable=false, unique=true, name="ID_TECNICO_AGRICOLA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_TECNICO_AGRICOLA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, unique=true, name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_TECNICO_AGRICOLA_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_TECNICO_AGRICOLA_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Column(name="DATA_ATUALIZACAO")
    @Version
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="CREA", length=15)
    public String getCrea() {
        return this.crea;
    }

    public void setCrea(String crea) {
        this.crea = crea;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getPessoa()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="COD_SINCRONIZACAO", length=20)
    public String getCodSincronizacao() {
        return this.codSincronizacao;
    }

    public void setCodSincronizacao(String codSincronizacao) {
        this.codSincronizacao = codSincronizacao;
    }

    @Column(name="COD_PROV_SERVIOC_REC")
    public Short getCodProvServicoRec() {
        return this.codProvServicoRec;
    }

    public void setCodProvServicoRec(Short codProvServicoRec) {
        this.codProvServicoRec = codProvServicoRec;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_ATUALIZACAO_SIS_TERC")
    public Date getDataAtualizacaoSisTerc() {
        return this.dataAtualizacaoSisTerc;
    }

    public void setDataAtualizacaoSisTerc(Date dataAtualizacaoSisTerc) {
        this.dataAtualizacaoSisTerc = dataAtualizacaoSisTerc;
    }

    @Column(name="ART_PRIMARIA")
    public Long getArtPrimaria() {
        return this.artPrimaria;
    }

    public void setArtPrimaria(Long artPrimaria) {
        this.artPrimaria = artPrimaria;
    }

    @Column(name="ART_SECUNDARIA")
    public Long getArtSecundaria() {
        return this.artSecundaria;
    }

    public void setArtSecundaria(Long artSecundaria) {
        this.artSecundaria = artSecundaria;
    }

    @Column(name="NR_COPIAS")
    public Integer getNrCopias() {
        return this.nrCopias;
    }

    public void setNrCopias(Integer nrCopias) {
        this.nrCopias = nrCopias;
    }

    @Column(name="NR_ULTIMA_RECEITA")
    public Long getNrUltimaReceita() {
        return this.nrUltimaReceita;
    }

    public void setNrUltimaReceita(Long nrUltimaReceita) {
        this.nrUltimaReceita = nrUltimaReceita;
    }

    @Column(name="FORMATO_RECEITA")
    public Integer getFormatoReceita() {
        return this.formatoReceita;
    }

    public void setFormatoReceita(Integer formatoReceita) {
        this.formatoReceita = formatoReceita;
    }

    @Column(name="BUSCAR_ART")
    public Short getBuscarArt() {
        return this.buscarArt;
    }

    public void setBuscarArt(Short buscarArt) {
        this.buscarArt = buscarArt;
    }

    @Column(name="NR_RECEITARS_ART")
    public Long getNrReceitasArt() {
        return this.nrReceitasArt;
    }

    public void setNrReceitasArt(Long nrReceitasArt) {
        this.nrReceitasArt = nrReceitasArt;
    }

    @Column(name="NR_RECEITARS_MES")
    public Long getNrReceitasMes() {
        return this.nrReceitasMes;
    }

    public void setNrReceitasMes(Long nrReceitasMes) {
        this.nrReceitasMes = nrReceitasMes;
    }

    @Column(name="LOGIN", length=100)
    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    @Column(name="SENHA", length=100)
    public String getSenha() {
        return this.senha;
    }

    public void setSenha(String senha) {
        this.senha = senha;
    }

    @Column(name="TITULO", length=300)
    public String getTitulo() {
        return this.titulo;
    }

    public void setTitulo(String titulo) {
        this.titulo = titulo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONFIGURACAO_CERTIFICADO", foreignKey=@ForeignKey(name="FK_TECNICO_AGR_CONF_CERTIFICADO"))
    public ConfiguracaoCertificado getConfiguracaoCertificado() {
        return this.configuracaoCertificado;
    }

    public void setConfiguracaoCertificado(ConfiguracaoCertificado configuracaoCertificado) {
        this.configuracaoCertificado = configuracaoCertificado;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @OneToMany(mappedBy="tecnicoAgricola", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<TecnicoAgricolaCREA> getTecnicoAgrCrea() {
        return this.tecnicoAgrCrea;
    }

    public void setTecnicoAgrCrea(List<TecnicoAgricolaCREA> tecnicoAgrCrea) {
        this.tecnicoAgrCrea = tecnicoAgrCrea;
    }

    @Column(name="COD_SINCRONIZACAO_2")
    public String getCodSincronizacao2() {
        return this.codSincronizacao2;
    }

    public void setCodSincronizacao2(String codSincronizacao2) {
        this.codSincronizacao2 = codSincronizacao2;
    }
}

