/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.ticketfiscalterceiros.EnumConstTicketFiscalTerceirosStatus;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.ConversaoProdutos;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FichaTecTicFiscTerc;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="TICKET_FISCAL_TERCEIROS")
public class TicketFiscalTerceiros
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Long numero = 0L;
    private Long numeroInfManual;
    private String codigoBarras;
    private UnidadeFatFornecedor unidadeFatFornecedor;
    private Date dataTicket;
    private Date horaTicket;
    private Transportador transportador;
    private String placa;
    private GradeCor gradeCor;
    private LoteFabricacao loteFabricacao;
    private Double pesoBruto = 0.0;
    private Double pesoLiquido = 0.0;
    private Double pesoBrutoBalanca = 0.0;
    private Double pesoLiquidoBalanca = 0.0;
    private Double pesoTara = 0.0;
    private Empresa empresa;
    private String observacao;
    private String nomeMotorista;
    private String cpfMotorista;
    private Produto produto;
    private ConversaoProdutos conversaoProdutos;
    private Short status;
    private CentroEstoque centroEstoque;
    private Short infManualPeso;
    private String motivoManualPeso;
    private Double valorPrecoMedio;
    private NotaFiscalTerceiros notaTerceiros;
    private Short movimentarEstoque;
    private String chaveNotaFiscalEntrada;
    private List<FichaTecTicFiscTerc> fichasTecnicas;

    public TicketFiscalTerceiros() {
        this.status = EnumConstTicketFiscalTerceirosStatus.ABERTO.value;
        this.infManualPeso = EnumConstantsMentorSimNao.NAO.value;
        this.movimentarEstoque = EnumConstantsMentorSimNao.NAO.value;
        this.valorPrecoMedio = 0.0;
        this.fichasTecnicas = new ArrayList<FichaTecTicFiscTerc>();
    }

    @Id
    @Column(name="ID_TICKET_FISCAL_TERCEIROS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_TICKET_FISCAL_TERCEIROS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Generated(value=GenerationTime.ALWAYS)
    @Column(name="NUMERO")
    public Long getNumero() {
        return this.numero;
    }

    public void setNumero(Long numero) {
        this.numero = numero;
    }

    @Column(name="CODIGO_BARRAS", length=14)
    public String getCodigoBarras() {
        return this.codigoBarras;
    }

    public void setCodigoBarras(String codigoBarras) {
        this.codigoBarras = codigoBarras;
    }

    @JoinColumn(name="ID_UNIDADE_FAT_FORNECEDOR", foreignKey=@ForeignKey(name="FK_TICKET_FISCAL_TERC_UN_F_F"))
    @ManyToOne(fetch=FetchType.LAZY)
    public UnidadeFatFornecedor getUnidadeFatFornecedor() {
        return this.unidadeFatFornecedor;
    }

    public void setUnidadeFatFornecedor(UnidadeFatFornecedor unidadeFatFornecedor) {
        this.unidadeFatFornecedor = unidadeFatFornecedor;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_TICKET")
    public Date getDataTicket() {
        return this.dataTicket;
    }

    public void setDataTicket(Date dataTicket) {
        this.dataTicket = dataTicket;
    }

    @JoinColumn(name="ID_TRANSPORTADOR", foreignKey=@ForeignKey(name="FK_TICKET_FISCAL_TERC_TRANSP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Transportador getTransportador() {
        return this.transportador;
    }

    public void setTransportador(Transportador transportador) {
        this.transportador = transportador;
    }

    @Column(name="PLACA", length=7)
    public String getPlaca() {
        return this.placa;
    }

    public void setPlaca(String placa) {
        this.placa = placa;
    }

    @JoinColumn(name="ID_GRADE_COR", foreignKey=@ForeignKey(name="FK_TICKET_FISCAL_TERC_GRADE_COR"))
    @ManyToOne(fetch=FetchType.LAZY)
    public GradeCor getGradeCor() {
        return this.gradeCor;
    }

    public void setGradeCor(GradeCor gradeCor) {
        this.gradeCor = gradeCor;
    }

    @JoinColumn(name="ID_LOTE_FABRICACAO", foreignKey=@ForeignKey(name="FK_TICKET_FISCAL_TERC_LOTE_FAB"))
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH})
    public LoteFabricacao getLoteFabricacao() {
        return this.loteFabricacao;
    }

    public void setLoteFabricacao(LoteFabricacao loteFabricacao) {
        this.loteFabricacao = loteFabricacao;
    }

    @Column(name="PESO_BRUTO", precision=15, scale=6)
    public Double getPesoBruto() {
        return this.pesoBruto;
    }

    public void setPesoBruto(Double pesoBruto) {
        this.pesoBruto = pesoBruto;
    }

    @Column(name="PESO_LIQUIDO", precision=15, scale=6)
    public Double getPesoLiquido() {
        return this.pesoLiquido;
    }

    public void setPesoLiquido(Double pesoLiquido) {
        this.pesoLiquido = pesoLiquido;
    }

    @Column(name="PESO_BRUTO_BALANCA", precision=15, scale=6)
    public Double getPesoBrutoBalanca() {
        return this.pesoBrutoBalanca;
    }

    public void setPesoBrutoBalanca(Double pesoBrutoBalanca) {
        this.pesoBrutoBalanca = pesoBrutoBalanca;
    }

    @Column(name="PESO_LIQUIDO_BALANCA", precision=15, scale=6)
    public Double getPesoLiquidoBalanca() {
        return this.pesoLiquidoBalanca;
    }

    public void setPesoLiquidoBalanca(Double pesoLiquidoBalanca) {
        this.pesoLiquidoBalanca = pesoLiquidoBalanca;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_TICKET_FISCAL_TERC_EMP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="OBSERVACAO", length=1000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(name="NOME_MOTORISTA", length=100)
    public String getNomeMotorista() {
        return this.nomeMotorista;
    }

    public void setNomeMotorista(String nomeMotorista) {
        this.nomeMotorista = nomeMotorista;
    }

    @Column(name="CPF_MOTORISTA", length=11)
    public String getCpfMotorista() {
        return this.cpfMotorista;
    }

    public void setCpfMotorista(String cpfMotorista) {
        this.cpfMotorista = cpfMotorista;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"Nr: {0} - Forn: {1}", (Object[])new Object[]{this.getNumero(), this.getUnidadeFatFornecedor() != null ? this.getUnidadeFatFornecedor() : null});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRODUTO", foreignKey=@ForeignKey(name="FK_TICKET_FISCAL_TERC_PRODUTO"))
    public Produto getProduto() {
        return this.produto;
    }

    public void setProduto(Produto produto) {
        this.produto = produto;
    }

    @OneToOne(mappedBy="ticketFiscalTerceiros", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public ConversaoProdutos getConversaoProdutos() {
        return this.conversaoProdutos;
    }

    public void setConversaoProdutos(ConversaoProdutos conversaoProdutos) {
        this.conversaoProdutos = conversaoProdutos;
    }

    @Column(name="STATUS")
    public Short getStatus() {
        return this.status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_ESTOQUE", foreignKey=@ForeignKey(name="FK_TICKET_FISCAL_TERCEIROS_C_E"))
    public CentroEstoque getCentroEstoque() {
        return this.centroEstoque;
    }

    public void setCentroEstoque(CentroEstoque centroEstoque) {
        this.centroEstoque = centroEstoque;
    }

    @Column(name="PESO_TARA", precision=15, scale=6)
    public Double getPesoTara() {
        return this.pesoTara;
    }

    public void setPesoTara(Double pesoTara) {
        this.pesoTara = pesoTara;
    }

    @Column(name="INF_MANUAL_PESO")
    public Short getInfManualPeso() {
        return this.infManualPeso;
    }

    public void setInfManualPeso(Short infManualPeso) {
        this.infManualPeso = infManualPeso;
    }

    @Column(name="MOTIVO_MANUAL_PESO", length=500)
    public String getMotivoManualPeso() {
        return this.motivoManualPeso;
    }

    public void setMotivoManualPeso(String motivoManualPeso) {
        this.motivoManualPeso = motivoManualPeso;
    }

    @Column(name="VALOR_PRECO_MEDIO", precision=15, scale=6)
    public Double getValorPrecoMedio() {
        return this.valorPrecoMedio;
    }

    public void setValorPrecoMedio(Double valorPrecoMedio) {
        this.valorPrecoMedio = valorPrecoMedio;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NOTA_TERCEIROS", foreignKey=@ForeignKey(name="FK_TICKET_FISCAL_TERC_NF_TERC"))
    public NotaFiscalTerceiros getNotaTerceiros() {
        return this.notaTerceiros;
    }

    public void setNotaTerceiros(NotaFiscalTerceiros notaTerceiros) {
        this.notaTerceiros = notaTerceiros;
    }

    @Temporal(value=TemporalType.TIME)
    @Column(name="HORA_TICKET")
    public Date getHoraTicket() {
        return this.horaTicket;
    }

    public void setHoraTicket(Date horaTicket) {
        this.horaTicket = horaTicket;
    }

    @Ignore
    @Column(name="NUMERO_INF_MANUAL")
    public Long getNumeroInfManual() {
        return this.numeroInfManual;
    }

    public void setNumeroInfManual(Long numeroInfManual) {
        this.numeroInfManual = numeroInfManual;
    }

    @Column(name="MOVIMENTAR_ESTOQUE")
    public Short getMovimentarEstoque() {
        return this.movimentarEstoque;
    }

    public void setMovimentarEstoque(Short movimentarEstoque) {
        this.movimentarEstoque = movimentarEstoque;
    }

    @Column(name="CHAVE_NOTA_FISCAL_ENTRADA", length=44)
    public String getChaveNotaFiscalEntrada() {
        return this.chaveNotaFiscalEntrada;
    }

    public void setChaveNotaFiscalEntrada(String chaveNotaFiscalEntrada) {
        this.chaveNotaFiscalEntrada = chaveNotaFiscalEntrada;
    }

    @OneToMany(mappedBy="ticketFiscalTerceiros", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<FichaTecTicFiscTerc> getFichasTecnicas() {
        return this.fichasTecnicas;
    }

    public void setFichasTecnicas(List<FichaTecTicFiscTerc> fichasTecnicas) {
        this.fichasTecnicas = fichasTecnicas;
    }
}

