/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="TIPO_BEM")
public class TipoBem
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private Short depreciar = EnumConstantsMentorSimNao.NAO.getValue();
    private Double taxaAnualDepreciacao = 0.0;
    private Short trabalhaTurnos = EnumConstantsMentorSimNao.NAO.getValue();
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private PlanoConta planoContaBem;
    private PlanoConta contaContabil;
    private Short utilizadoConstrucaoObra = EnumConstantsMentorSimNao.NAO.getValue();
    private Short ativo = EnumConstantsMentorSimNao.SIM.getValue();

    @Id
    @Column(name="ID_TIPO_BEM")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_TIPO_BEM")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DESCRICAO", length=60)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="DEPRECIAR")
    public Short getDepreciar() {
        return this.depreciar;
    }

    public void setDepreciar(Short depreciar) {
        this.depreciar = depreciar;
    }

    @Column(nullable=false, name="TAXA_ANUAL_DEPRECIACAO", precision=15, scale=2)
    public Double getTaxaAnualDepreciacao() {
        return this.taxaAnualDepreciacao;
    }

    public void setTaxaAnualDepreciacao(Double taxaAnualDepreciacao) {
        this.taxaAnualDepreciacao = taxaAnualDepreciacao;
    }

    @Column(name="TRABALHA_TURNOS")
    public Short getTrabalhaTurnos() {
        return this.trabalhaTurnos;
    }

    public void setTrabalhaTurnos(Short trabalhaTurnos) {
        this.trabalhaTurnos = trabalhaTurnos;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_TIPO_BEM_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @JoinColumn(name="ID_PLANO_CONTA_BEM", foreignKey=@ForeignKey(name="FK_TIPO_BEM_PC_BEM"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PlanoConta getPlanoContaBem() {
        return this.planoContaBem;
    }

    public void setPlanoContaBem(PlanoConta planoConta) {
        this.planoContaBem = planoConta;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONTA_CONTABIL", foreignKey=@ForeignKey(name="FK_TIPO_BEM_PCONTABIL"))
    public PlanoConta getContaContabil() {
        return this.contaContabil;
    }

    public void setContaContabil(PlanoConta contaContabil) {
        this.contaContabil = contaContabil;
    }

    @Column(name="UTILIZAR_CONSTRUCAO_OBRA")
    public Short getUtilizadoConstrucaoObra() {
        return this.utilizadoConstrucaoObra;
    }

    public void setUtilizadoConstrucaoObra(Short utilizadoConstrucaoObra) {
        this.utilizadoConstrucaoObra = utilizadoConstrucaoObra;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }
}

