/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoTipoDoc;
import com.touchcomp.basementor.model.vo.IncidenciaPisCofins;
import com.touchcomp.basementor.model.vo.LancContAdicDocFinanceiro;
import com.touchcomp.basementor.model.vo.NaturezaBCCredito;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="TIPO_DOC_FINANCEIRO", uniqueConstraints={@UniqueConstraint(name="UNQ1_TIPO_DOC_FINANCEIRO_NOME", columnNames={"NOME"})})
public class TipoDoc
implements InterfaceVO {
    private static final long serialVersionUID = 3955409780926988287L;
    private Long identificador;
    private String nome;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private List<LancContAdicDocFinanceiro> lancContAdicionais;
    private Short obrigarLancAdicionais;
    private GrupoTipoDoc grupoTipoDoc;
    private Short gerarLancamentoPisCofins;
    private IncidenciaPisCofins incidenciaPisCofins;
    private Double aliquotaPis;
    private Double aliquotaCofins;
    private NaturezaBCCredito natBcCredito;
    private Short indOrigCred;
    private Short tipoTitulo;
    private Short ativo;

    public TipoDoc(Long identificador, String nome) {
        this.identificador = identificador;
        this.nome = nome;
        this.lancContAdicionais = new ArrayList<LancContAdicDocFinanceiro>();
        this.obrigarLancAdicionais = 0;
        this.gerarLancamentoPisCofins = 0;
        this.obrigarLancAdicionais = 0;
        this.indOrigCred = 0;
        this.aliquotaPis = 0.0;
        this.aliquotaCofins = 0.0;
        this.tipoTitulo = 2;
        this.ativo = EnumConstantsMentorSimNao.SIM.getValue();
    }

    public TipoDoc() {
        this.lancContAdicionais = new ArrayList<LancContAdicDocFinanceiro>();
        this.obrigarLancAdicionais = 0;
        this.gerarLancamentoPisCofins = 0;
        this.indOrigCred = 0;
        this.aliquotaPis = 0.0;
        this.aliquotaCofins = 0.0;
        this.tipoTitulo = 2;
        this.ativo = EnumConstantsMentorSimNao.SIM.getValue();
    }

    @Id
    @Column(name="ID_TIPO_DOC_FINANCEIRO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_TIPO_DOC_FINANCEIRO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(nullable=false, name="NOME", length=40)
    public String getNome() {
        return this.nome;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMP", foreignKey=@ForeignKey(name="FK_TIPO_DOC_FINANCEIRO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getNome()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @OneToMany(mappedBy="tipoDoc", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<LancContAdicDocFinanceiro> getLancContAdicionais() {
        return this.lancContAdicionais;
    }

    public void setLancContAdicionais(List<LancContAdicDocFinanceiro> lancContAdicionais) {
        this.lancContAdicionais = lancContAdicionais;
    }

    @Column(name="OBRIGAR_LANC_ADICIONAIS")
    public Short getObrigarLancAdicionais() {
        return this.obrigarLancAdicionais;
    }

    public void setObrigarLancAdicionais(Short obrigarLancAdicionais) {
        this.obrigarLancAdicionais = obrigarLancAdicionais;
    }

    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRUPO_TIPO_DOC", foreignKey=@ForeignKey(name="FK_TIPO_DOC_FIN_GRUPO_TIPO_DOC"))
    public GrupoTipoDoc getGrupoTipoDoc() {
        return this.grupoTipoDoc;
    }

    public void setGrupoTipoDoc(GrupoTipoDoc grupoTipoDoc) {
        this.grupoTipoDoc = grupoTipoDoc;
    }

    @Column(name="GERAR_LANCAMENTO_PIS_COFINS")
    public Short getGerarLancamentoPisCofins() {
        return this.gerarLancamentoPisCofins;
    }

    public void setGerarLancamentoPisCofins(Short gerarLancamentoPisCofins) {
        this.gerarLancamentoPisCofins = gerarLancamentoPisCofins;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INCIDENCIA_PIS_COFINS", foreignKey=@ForeignKey(name="FK_TIPO_DOC_FINANCINC_PIS_COFIN"))
    public IncidenciaPisCofins getIncidenciaPisCofins() {
        return this.incidenciaPisCofins;
    }

    public void setIncidenciaPisCofins(IncidenciaPisCofins incidenciaPisCofins) {
        this.incidenciaPisCofins = incidenciaPisCofins;
    }

    @Column(name="ALIQUOTA_PIS", precision=15, scale=4)
    public Double getAliquotaPis() {
        return this.aliquotaPis;
    }

    public void setAliquotaPis(Double aliquotaPis) {
        this.aliquotaPis = aliquotaPis;
    }

    @Column(name="ALIQUOTA_COFINS", precision=15, scale=4)
    public Double getAliquotaCofins() {
        return this.aliquotaCofins;
    }

    public void setAliquotaCofins(Double aliquotaCofins) {
        this.aliquotaCofins = aliquotaCofins;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NAT_BC_CREDITO", foreignKey=@ForeignKey(name="FK_TIPO_DOC_FINANC_NAT_BC_CRED"))
    public NaturezaBCCredito getNatBcCredito() {
        return this.natBcCredito;
    }

    public void setNatBcCredito(NaturezaBCCredito natBcCredito) {
        this.natBcCredito = natBcCredito;
    }

    @Column(name="IND_ORIG_CRED")
    public Short getIndOrigCred() {
        return this.indOrigCred;
    }

    public void setIndOrigCred(Short indOrigCred) {
        this.indOrigCred = indOrigCred;
    }

    @Column(name="TIPO_TITULO")
    public Short getTipoTitulo() {
        return this.tipoTitulo;
    }

    public void setTipoTitulo(Short tipoTitulo) {
        this.tipoTitulo = tipoTitulo;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }
}

