/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;

@Entity
@Table(name="TIPO_EQUIPAMENTO", uniqueConstraints={@UniqueConstraint(name="UNQ1_TIPO_EQUIPAMENTO_NOME", columnNames={"NOME"})})
public class TipoEquipamento
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private String nome;
    private Short ativo;
    private Short classificacaoEquipamento;

    public TipoEquipamento() {
        this.ativo = 1;
        this.classificacaoEquipamento = 0;
    }

    public TipoEquipamento(Long identificador, String nome) {
        this.identificador = identificador;
        this.nome = nome;
    }

    @Id
    @Column(nullable=false, name="ID_TIPO_EQUIPAMENTO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_TIPO_EQUIPAMENTO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_TIPO_EQUIPAMENTO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(nullable=false, name="NOME", length=80)
    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    @Column(nullable=false, name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getNome()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="CLASSIFICACAO_EQUIPAMENTO")
    public Short getClassificacaoEquipamento() {
        return this.classificacaoEquipamento;
    }

    public void setClassificacaoEquipamento(Short classificacaoEquipamento) {
        this.classificacaoEquipamento = classificacaoEquipamento;
    }
}

