/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ObsFaturamento;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="TIPO_FRETE", uniqueConstraints={@UniqueConstraint(name="UNQ1_TIPO_FRETE", columnNames={"DESCRICAO"})})
public class TipoFrete
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private String descricao;
    private Double percFrete = 0.0;
    private Double percSeguro = 0.0;
    private Short opcao = 0;
    private Short fretePorConta = 0;
    private Timestamp dataAtualizacao;
    private Short ativo;
    private List<ObsFaturamento> observacoes = new ArrayList<ObsFaturamento>();

    public TipoFrete() {
        this.ativo = EnumConstantsMentorSimNao.SIM.getValue();
    }

    @Id
    @Column(nullable=false, name="ID_TIPO_FRETE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_TIPO_FRETE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_TIPO_FRETE_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DESCRICAO", length=60)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(nullable=false, name="PERC_FRETE", precision=3, scale=2)
    public Double getPercFrete() {
        return this.percFrete;
    }

    public void setPercFrete(Double percFrete) {
        this.percFrete = percFrete;
    }

    @Column(nullable=false, name="PERC_SEGURO", precision=3, scale=2)
    public Double getPercSeguro() {
        return this.percSeguro;
    }

    public void setPercSeguro(Double percSeguro) {
        this.percSeguro = percSeguro;
    }

    @Column(name="OPCAO")
    public Short getOpcao() {
        return this.opcao;
    }

    public void setOpcao(Short opcao) {
        this.opcao = opcao;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="FRETE_POR_CONTA")
    public Short getFretePorConta() {
        return this.fretePorConta;
    }

    public void setFretePorConta(Short fretePorConta) {
        this.fretePorConta = fretePorConta;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

