/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.PosicaoTipoVeiculo;
import com.touchcomp.basementor.model.vo.TipoVeiculoCte;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="TIPO_VEICULO")
public class TipoVeiculo
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private TipoVeiculoCte tipoVeiculoCte;
    private List<PosicaoTipoVeiculo> posicoesVeiculo = new ArrayList<PosicaoTipoVeiculo>();
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;

    @Id
    @Column(name="ID_TIPO_VEICULO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_TIPO_VEICULO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DESCRICAO", length=500)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @OneToOne(targetEntity=TipoVeiculoCte.class, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_VEICULO_CTE", foreignKey=@ForeignKey(name="FK_TIPO_VEICULO_TP_VEIC_CTE"))
    public TipoVeiculoCte getTipoVeiculoCte() {
        return this.tipoVeiculoCte;
    }

    public void setTipoVeiculoCte(TipoVeiculoCte tipoVeiculoCte) {
        this.tipoVeiculoCte = tipoVeiculoCte;
    }

    @OneToMany(targetEntity=PosicaoTipoVeiculo.class, fetch=FetchType.LAZY)
    @JoinTable(name="TIPO_VEICULO_POSICAO", joinColumns={@JoinColumn(name="ID_TIPO_VEICULO")}, inverseJoinColumns={@JoinColumn(name="ID_POSICAO_VEICULO")})
    public List<PosicaoTipoVeiculo> getPosicoesVeiculo() {
        return this.posicoesVeiculo;
    }

    public void setPosicoesVeiculo(List<PosicaoTipoVeiculo> posicoesVeiculo) {
        this.posicoesVeiculo = posicoesVeiculo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_TIPO_VEICULO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

