/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.TransfEstoqueOSEncOS;
import com.touchcomp.basementor.model.vo.TransferenciaCentroEstoque;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="TRANSF_ESTOQUE_OS_ENC")
public class TransfEstoqueOSEnc
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private String descricao;
    private TransferenciaCentroEstoque transferenciaCentroEst;
    private String observacaoSistema;
    private List<TransfEstoqueOSEncOS> transfEstoqueOSEncOS = new ArrayList<TransfEstoqueOSEncOS>();
    private CentroEstoque centroEstoqueOrigem;
    private CentroEstoque centroEstoqueDestino;

    @Id
    @Column(nullable=false, name="ID_TRANSF_ESTOQUE_OS_ENC")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_TRANSF_ESTOQUE_OS_ENC")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_TRANSF_ESTOQUE_OS_ENC_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DESCRICAO", length=1000)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="OBSERVACAO_SISTEMA", length=5000)
    public String getObservacaoSistema() {
        return this.observacaoSistema;
    }

    public void setObservacaoSistema(String observacaoSistema) {
        this.observacaoSistema = observacaoSistema;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TRANSFERENCIA_CENTRO_EST", foreignKey=@ForeignKey(name="FK_TRANSF_ESTOQUE_OS_ENC_TR_C_E"))
    @Cascade(value={CascadeType.ALL})
    public TransferenciaCentroEstoque getTransferenciaCentroEst() {
        return this.transferenciaCentroEst;
    }

    public void setTransferenciaCentroEst(TransferenciaCentroEstoque transferenciaCentroEst) {
        this.transferenciaCentroEst = transferenciaCentroEst;
    }

    @OneToMany(mappedBy="transfEstoqueOSSobEnc", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<TransfEstoqueOSEncOS> getTransfEstoqueOSEncOS() {
        return this.transfEstoqueOSEncOS;
    }

    public void setTransfEstoqueOSEncOS(List<TransfEstoqueOSEncOS> transfEstoqueOSEncOS) {
        this.transfEstoqueOSEncOS = transfEstoqueOSEncOS;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_ESTOQUE_ORIGEM", foreignKey=@ForeignKey(name="FK_TRANSF_ESTOQUE_OS_ENC_C_ORIG"))
    public CentroEstoque getCentroEstoqueOrigem() {
        return this.centroEstoqueOrigem;
    }

    public void setCentroEstoqueOrigem(CentroEstoque centroEstoqueOrigem) {
        this.centroEstoqueOrigem = centroEstoqueOrigem;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_ESTOQUE_DESTINO", foreignKey=@ForeignKey(name="FK_TRANSF_ESTOQUE_OS_ENC_C_DEST"))
    public CentroEstoque getCentroEstoqueDestino() {
        return this.centroEstoqueDestino;
    }

    public void setCentroEstoqueDestino(CentroEstoque centroEstoqueDestino) {
        this.centroEstoqueDestino = centroEstoqueDestino;
    }
}

