/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.PlanejamentoProdLinhaProd;
import com.touchcomp.basementor.model.vo.TransfEstoquePCPLinItem;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="TRANSF_ESTOQUE_PCP_LIN")
public class TransfEstoquePCPLin
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private String descricao;
    private CentroEstoque centroEstoqueReserva;
    private List<TransfEstoquePCPLinItem> transferencias = new ArrayList<TransfEstoquePCPLinItem>();
    private PlanejamentoProdLinhaProd planejamentoProdLinhaProd;
    private String observacaoSistema;

    @Id
    @Column(nullable=false, name="ID_TRANSF_ESTOQUE_PCP_LIN")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_TRANSF_ESTOQUE_PCP_LIN")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_TRANSF_ESTOQUE_PCP_LIN_EMP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DESCRICAO", length=250)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="transfEstoquePCPLin")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<TransfEstoquePCPLinItem> getTransferencias() {
        return this.transferencias;
    }

    public void setTransferencias(List<TransfEstoquePCPLinItem> transferencias) {
        this.transferencias = transferencias;
    }

    @JoinColumn(name="ID_PLANEJAMENTO_PROD_LIN", foreignKey=@ForeignKey(name="FK_TRANSF_ESTOQUE_PCP_LIN_PLANE"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PlanejamentoProdLinhaProd getPlanejamentoProdLinhaProd() {
        return this.planejamentoProdLinhaProd;
    }

    public void setPlanejamentoProdLinhaProd(PlanejamentoProdLinhaProd planejamentoProdLinhaProd) {
        this.planejamentoProdLinhaProd = planejamentoProdLinhaProd;
    }

    @JoinColumn(name="ID_CENTRO_ESTOQUE_RESERVA", foreignKey=@ForeignKey(name="FK_TRANSF_ESTOQUE_PCP_LIN_C_EST"))
    @ManyToOne(fetch=FetchType.LAZY)
    public CentroEstoque getCentroEstoqueReserva() {
        return this.centroEstoqueReserva;
    }

    public void setCentroEstoqueReserva(CentroEstoque centroEstoqueReserva) {
        this.centroEstoqueReserva = centroEstoqueReserva;
    }

    @Column(name="OBSERVACAO_SISTEMA", length=10000)
    public String getObservacaoSistema() {
        return this.observacaoSistema;
    }

    public void setObservacaoSistema(String observacaoSistema) {
        this.observacaoSistema = observacaoSistema;
    }
}

