/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.PlanejamentoProdSobEnc;
import com.touchcomp.basementor.model.vo.TransfEstoquePCPSobEncItem;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="TRANSF_ESTOQUE_PCP_S_ENC")
public class TransfEstoquePCPSobEnc
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private String descricao;
    private CentroEstoque centroEstoqueReserva;
    private List<TransfEstoquePCPSobEncItem> transferencias = new ArrayList<TransfEstoquePCPSobEncItem>();
    private PlanejamentoProdSobEnc planejamentoProdSobEnc;
    private String observacaoSistema;

    @Id
    @Column(nullable=false, name="ID_TRANSF_ESTOQUE_PCP_S_ENC")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_TRANSF_ESTOQUE_PCP_S_ENC")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_TRANSF_EST_PCP_S_ENC_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DESCRICAO", length=300)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="transfEstoqueSobEnc")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<TransfEstoquePCPSobEncItem> getTransferencias() {
        return this.transferencias;
    }

    public void setTransferencias(List<TransfEstoquePCPSobEncItem> transferencias) {
        this.transferencias = transferencias;
    }

    @JoinColumn(name="ID_PLANEJAMENTO_PROD_S_ENC", foreignKey=@ForeignKey(name="FK_TRANSF_EST_PCP_S_ENC_PL_S_EN"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PlanejamentoProdSobEnc getPlanejamentoProdSobEnc() {
        return this.planejamentoProdSobEnc;
    }

    public void setPlanejamentoProdSobEnc(PlanejamentoProdSobEnc planejamentoProdSobEnc) {
        this.planejamentoProdSobEnc = planejamentoProdSobEnc;
    }

    @JoinColumn(name="ID_CENTRO_ESTOQUE_RESERVA", foreignKey=@ForeignKey(name="FK_TRANSF_EST_PCP_S_ENC_CC_RES"))
    @ManyToOne(fetch=FetchType.LAZY)
    public CentroEstoque getCentroEstoqueReserva() {
        return this.centroEstoqueReserva;
    }

    public void setCentroEstoqueReserva(CentroEstoque centroEstoqueReserva) {
        this.centroEstoqueReserva = centroEstoqueReserva;
    }

    @Column(name="OBSERVACAO_SISTEMA", length=5000)
    public String getObservacaoSistema() {
        return this.observacaoSistema;
    }

    public void setObservacaoSistema(String observacaoSistema) {
        this.observacaoSistema = observacaoSistema;
    }
}

