/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemTransferenciaColaboradorCentroCusto;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="TRANS_COL_CENTRO_CUSTO")
public class TransferenciaColaboradorCentroCusto
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Date periodo;
    private CentroCusto origem;
    private CentroCusto destino;
    private List<ItemTransferenciaColaboradorCentroCusto> itemColaboradorCentroCusto = new ArrayList<ItemTransferenciaColaboradorCentroCusto>();

    @Id
    @Column(nullable=false, unique=true, name="ID_TRANS_COL_CENTRO_CUSTO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_TRANS_COL_CENTRO_CUSTO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_TRANS_COL_CENTRO_CUSTO_EMPRE"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="PERIODO")
    public Date getPeriodo() {
        return this.periodo;
    }

    public void setPeriodo(Date periodo) {
        this.periodo = periodo;
    }

    @JoinColumn(name="ID_CENTRO_CUSTO_ORIGEM", foreignKey=@ForeignKey(name="FK_TRANS_COL_CENTRO_CUSTO_ORIG"))
    @ManyToOne(fetch=FetchType.LAZY)
    public CentroCusto getOrigem() {
        return this.origem;
    }

    public void setOrigem(CentroCusto origem) {
        this.origem = origem;
    }

    @JoinColumn(name="ID_CENTRO_CUSTO_DESTINO", foreignKey=@ForeignKey(name="FK_TRANS_COL_CENTRO_CUSTO_DEST"))
    @ManyToOne(fetch=FetchType.LAZY)
    public CentroCusto getDestino() {
        return this.destino;
    }

    public void setDestino(CentroCusto destino) {
        this.destino = destino;
    }

    @OneToMany(mappedBy="transferenciaColaboradorCentroCusto")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ItemTransferenciaColaboradorCentroCusto> getItemColaboradorCentroCusto() {
        return this.itemColaboradorCentroCusto;
    }

    public void setItemColaboradorCentroCusto(List<ItemTransferenciaColaboradorCentroCusto> itemColaboradorCentroCusto) {
        this.itemColaboradorCentroCusto = itemColaboradorCentroCusto;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

