/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Cheque;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.HistoricoPadrao;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.MovimentoBancario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="TRANSFERENCIA_CONTA_VALOR")
public class TransferenciaContaValor
implements InterfaceVO {
    private Long identificador;
    private ContaValores contaOrigem;
    private ContaValores contaDestino;
    private HistoricoPadrao historicoPadrao;
    private String historico;
    private Double valor = 0.0;
    private LoteContabil loteContabil;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Date dataTransferencia;
    private List<MovimentoBancario> movBanc = new ArrayList<MovimentoBancario>();
    private List<Cheque> cheque = new ArrayList<Cheque>();
    private Short naoContabilizarTransf = 1;

    @Id
    @Column(name="ID_TRANSF_CONTA_VLR")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_TRANSFERENCIA_CONTA_VALOR")
    public Long getIdentificador() {
        return this.identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONTA_VALOR_ORIGEM", foreignKey=@ForeignKey(name="FK_TRANSF_CONTA_VALOR_CONT_ORIG"))
    public ContaValores getContaOrigem() {
        return this.contaOrigem;
    }

    @OneToMany(mappedBy="transferenciaValor", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<MovimentoBancario> getMovBanc() {
        return this.movBanc;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONTA_VALOR_DESTINO", foreignKey=@ForeignKey(name="FK_TRANSF_CONTA_VALOR_CONT_DEST"))
    public ContaValores getContaDestino() {
        return this.contaDestino;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinTable(name="cheques_transf_cont_valor", joinColumns={@JoinColumn(name="ID_transf_conta_vlr")}, inverseJoinColumns={@JoinColumn(name="id_cheque")})
    public List<Cheque> getCheque() {
        return this.cheque;
    }

    @JoinColumn(name="ID_HISTORICO_PADRAO", foreignKey=@ForeignKey(name="FK_TRANSF_CONTA_VALOR_HIST_PADR"))
    @ManyToOne(fetch=FetchType.LAZY)
    public HistoricoPadrao getHistoricoPadrao() {
        return this.historicoPadrao;
    }

    @Column(name="HISTORICO", length=500)
    public String getHistorico() {
        return this.historico;
    }

    @Column(nullable=false, name="VALOR", precision=15, scale=2)
    public Double getValor() {
        return this.valor;
    }

    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOTE_CONTABIL", foreignKey=@ForeignKey(name="FK_TRANSF_CONTA_VALOR_LT_CONT"))
    public LoteContabil getLoteContabil() {
        return this.loteContabil;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_TRANSF_CONTA_VALOR_EMP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_TRANSFERENCIA")
    public Date getDataTransferencia() {
        return this.dataTransferencia;
    }

    public void setDataTransferencia(Date dataTransferencia) {
        this.dataTransferencia = dataTransferencia;
    }

    public void setCheque(List<Cheque> cheque) {
        this.cheque = cheque;
    }

    public void setMovBanc(List<MovimentoBancario> movBanc) {
        this.movBanc = movBanc;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setContaOrigem(ContaValores contaOrigem) {
        this.contaOrigem = contaOrigem;
    }

    public void setLoteContabil(LoteContabil loteContabil) {
        this.loteContabil = loteContabil;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    public void setHistoricoPadrao(HistoricoPadrao historicoPadrao) {
        this.historicoPadrao = historicoPadrao;
    }

    public void setContaDestino(ContaValores contaDestino) {
        this.contaDestino = contaDestino;
    }

    public void setHistorico(String historico) {
        this.historico = historico;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="NAO_CONTABILIZAR_TRANSF")
    public Short getNaoContabilizarTransf() {
        return this.naoContabilizarTransf;
    }

    public void setNaoContabilizarTransf(Short naoContabilizarTransf) {
        this.naoContabilizarTransf = naoContabilizarTransf;
    }
}

