/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ComplementoTranspRedes;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EnderecoTranspRedes;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="TRANSPORTADOR_REDESPACHO")
public class TransportadorRedespacho
implements InterfaceVO {
    private Short ativo = 1;
    private Long identificador;
    private String nome;
    private String nomeFantasia;
    private String pessoaContato;
    private EnderecoTranspRedes endereco;
    private ComplementoTranspRedes complemento;
    private Timestamp dataAtualizacao;
    private Date dataCadastro;
    private Empresa empresa;

    @Id
    @Column(name="ID_TRANSP_REDESPACHO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_TRANSP_REDESPACHO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(nullable=false, name="NOME", length=60)
    public String getNome() {
        return this.nome;
    }

    @Column(name="NOME_FANTASIA", length=60)
    public String getNomeFantasia() {
        return this.nomeFantasia;
    }

    @Column(nullable=true, name="PESSOA_CONTATO", length=60)
    public String getPessoaContato() {
        return this.pessoaContato;
    }

    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(nullable=false, name="ID_ENDERECO", foreignKey=@ForeignKey(name="FK_TRANSPORTADOR_REDES_ENDERECO"))
    public EnderecoTranspRedes getEndereco() {
        return this.endereco;
    }

    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(nullable=false, name="ID_COMPLEMENTO", foreignKey=@ForeignKey(name="FK_TRANSPORTADOR_REDES_COMPLEME"))
    public ComplementoTranspRedes getComplemento() {
        return this.complemento;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public void setEndereco(EnderecoTranspRedes endereco) {
        this.endereco = endereco;
    }

    public void setNomeFantasia(String nomeFantasia) {
        this.nomeFantasia = nomeFantasia;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setComplemento(ComplementoTranspRedes complemento) {
        this.complemento = complemento;
    }

    public void setPessoaContato(String pessoaContato) {
        this.pessoaContato = pessoaContato;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getNome()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(nullable=false, name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_TRANSPORTADOR_REDES_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }
}

