/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.clientetouchcomp.EnumStatTreinamentoUsuario;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ModuloSistema;
import com.touchcomp.basementor.model.vo.RelPessoaContatoTreinamento;
import com.touchcomp.basementor.model.vo.TreinamentoAvaliacoes;
import com.touchcomp.basementor.model.vo.UsuarioClienteContSistemas;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="TREINAMENTO_CONT_SISTEMAS")
public class TreinamentoContSistemas
implements InterfaceVO {
    private Long identificador;
    private UsuarioClienteContSistemas usuario;
    private ModuloSistema modulo;
    private Date dataTreinamento;
    private Short status = EnumStatTreinamentoUsuario.NAO_TREINADO.getValue();
    private List<RelPessoaContatoTreinamento> relacionamentos = new LinkedList<RelPessoaContatoTreinamento>();
    private List<TreinamentoAvaliacoes> avaliacoes = new LinkedList<TreinamentoAvaliacoes>();

    @Id
    @Column(nullable=false, name="ID_TREINAMENTO_CONT_SISTEMAS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_TREINAMENTO_CONT_SISTEMAS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @JoinColumn(name="ID_MODULO_SISTEMA", foreignKey=@ForeignKey(name="FK_TREINAMENTO_CONT_SIST_MODULO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ModuloSistema getModulo() {
        return this.modulo;
    }

    public void setModulo(ModuloSistema modulo) {
        this.modulo = modulo;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_TREINAMENTO")
    public Date getDataTreinamento() {
        return this.dataTreinamento;
    }

    public void setDataTreinamento(Date dataTreinamento) {
        this.dataTreinamento = dataTreinamento;
    }

    @Column(name="STATUS")
    public Short getStatus() {
        return this.status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @JoinColumn(name="ID_USUARIO_CLIENTE_CONTATO", foreignKey=@ForeignKey(name="FK_TREINAMENTO_CONT_SIST_USUARI"))
    @ManyToOne(fetch=FetchType.LAZY)
    public UsuarioClienteContSistemas getUsuario() {
        return this.usuario;
    }

    public void setUsuario(UsuarioClienteContSistemas usuario) {
        this.usuario = usuario;
    }

    @OneToMany(mappedBy="treinamento", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<RelPessoaContatoTreinamento> getRelacionamentos() {
        return this.relacionamentos;
    }

    public void setRelacionamentos(List<RelPessoaContatoTreinamento> relacionamentos) {
        this.relacionamentos = relacionamentos;
    }

    @OneToMany(mappedBy="treinamentoContSistemas", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<TreinamentoAvaliacoes> getAvaliacoes() {
        return this.avaliacoes;
    }

    public void setAvaliacoes(List<TreinamentoAvaliacoes> avaliacoes) {
        this.avaliacoes = avaliacoes;
    }
}

