/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.ItemTrocaSubComponenteAtivo;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="TROCA_SUB_COMPONENTE_ATIVO")
public class TrocaSubComponenteAtivo
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private Usuario usuario;
    private Equipamento ativoSubComponente;
    private Equipamento ativoPrincipal;
    private Equipamento ativoDestino;
    private List<ItemTrocaSubComponenteAtivo> itemTrocaSubComponenteAtivo = new ArrayList<ItemTrocaSubComponenteAtivo>();

    @Id
    @Column(nullable=false, name="ID_TROCA_SUB_COMPONENTE_ATIVO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_TROCA_SUB_COMPONENTE_ATIVO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_TROCA_SUB_COMP_ATIVO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_TROCA_SUB_COMP_ATIVO_USUARIO"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ATIVO_SUB_COMPONENTE", foreignKey=@ForeignKey(name="FK_TROCA_SUB_COMP_ATIVO_AT_SUB"))
    public Equipamento getAtivoSubComponente() {
        return this.ativoSubComponente;
    }

    public void setAtivoSubComponente(Equipamento ativoSubComponente) {
        this.ativoSubComponente = ativoSubComponente;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ATIVO_PRINCIPAL", foreignKey=@ForeignKey(name="FK_TROCA_SUB_COMP_ATIVO_AT_PRIN"))
    public Equipamento getAtivoPrincipal() {
        return this.ativoPrincipal;
    }

    public void setAtivoPrincipal(Equipamento ativoPrincipal) {
        this.ativoPrincipal = ativoPrincipal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ATIVO_DESTINO", foreignKey=@ForeignKey(name="FK_TROCA_SUB_COMP_ATIVO_AT_DEST"))
    public Equipamento getAtivoDestino() {
        return this.ativoDestino;
    }

    public void setAtivoDestino(Equipamento ativoDestino) {
        this.ativoDestino = ativoDestino;
    }

    @OneToMany(mappedBy="trocaSubComponenteAtivo", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    public List<ItemTrocaSubComponenteAtivo> getItemTrocaSubComponenteAtivo() {
        return this.itemTrocaSubComponenteAtivo;
    }

    public void setItemTrocaSubComponenteAtivo(List<ItemTrocaSubComponenteAtivo> itemTrocaSubComponenteAtivo) {
        this.itemTrocaSubComponenteAtivo = itemTrocaSubComponenteAtivo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

