/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.constants.enums.usuario.EnumConstTipoUsuario;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.GrupoUsuariosMobile;
import com.touchcomp.basementor.model.vo.SetorUsuario;
import com.touchcomp.basementor.model.vo.UsuarioBasico;
import com.touchcomp.basementor.model.vo.UsuarioConfiguracoes;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="USUARIO")
public class Usuario
implements InterfaceVO {
    private Long identificador;
    private UsuarioBasico usuarioBasico;
    private SetorUsuario setorUsuario;
    private Timestamp dataAtualizacao;
    private GrupoUsuariosMobile grupoUsuariosMobile;
    private String codigoRegistro;
    private Date dataSincTouch;
    private Date dataUltModificacao;
    private Short tipoUsuario = EnumConstTipoUsuario.USUARIO_CONVENCIONAL_HUMANO.getValue();
    private Long tempoExpiracaoToken = 0L;
    private String userAccessToken;
    private UsuarioConfiguracoes usuarioConfiguracoes;
    private Short ativo = 1;

    @Id
    @Column(name="ID_USUARIO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_USUARIO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentitificador(Long idUsuario) {
        this.setIdentificador(idUsuario);
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getUsuarioBasico() != null ? this.getUsuarioBasico().getPessoa() : this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @JoinColumn(name="ID_SETOR_USUARIO", foreignKey=@ForeignKey(name="FK_USUARIO_SETOR_USUARIO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public SetorUsuario getSetorUsuario() {
        return this.setorUsuario;
    }

    public void setSetorUsuario(SetorUsuario setorUsuario) {
        this.setorUsuario = setorUsuario;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @JoinColumn(name="ID_GRUPO_USUARIOS_MOBILE", foreignKey=@ForeignKey(name="FK_USUARIO_GR_MOBILE"))
    @ManyToOne(fetch=FetchType.LAZY)
    public GrupoUsuariosMobile getGrupoUsuariosMobile() {
        return this.grupoUsuariosMobile;
    }

    public void setGrupoUsuariosMobile(GrupoUsuariosMobile grupoUsuariosMobile) {
        this.grupoUsuariosMobile = grupoUsuariosMobile;
    }

    @Ignore
    @Column(name="CODIGO_REGISTRO", length=1500)
    public String getCodigoRegistro() {
        return this.codigoRegistro;
    }

    public void setCodigoRegistro(String codigoRegistro) {
        this.codigoRegistro = codigoRegistro;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_REG_AT_TOUCH")
    public Date getDataSincTouch() {
        return this.dataSincTouch;
    }

    public void setDataSincTouch(Date dataSincTouch) {
        this.dataSincTouch = dataSincTouch;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_ULT_MODIFICACAO")
    public Date getDataUltModificacao() {
        return this.dataUltModificacao;
    }

    public void setDataUltModificacao(Date dataUltModificacao) {
        this.dataUltModificacao = dataUltModificacao;
    }

    @Column(name="TIPO_USUARIO")
    public Short getTipoUsuario() {
        return this.tipoUsuario;
    }

    public void setTipoUsuario(Short tipoUsuario) {
        this.tipoUsuario = tipoUsuario;
    }

    @Column(name="TEMPO_EXPIRACAO_TOKEN")
    public Long getTempoExpiracaoToken() {
        return this.tempoExpiracaoToken;
    }

    public void setTempoExpiracaoToken(Long tempoExpiracaoToken) {
        this.tempoExpiracaoToken = tempoExpiracaoToken;
    }

    @Column(name="USER_ACESS_TOKEN")
    public String getUserAccessToken() {
        return this.userAccessToken;
    }

    public void setUserAccessToken(String userAccessToken) {
        this.userAccessToken = userAccessToken;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_USUARIO_CONFIGURACOES")
    public UsuarioConfiguracoes getUsuarioConfiguracoes() {
        return this.usuarioConfiguracoes;
    }

    public void setUsuarioConfiguracoes(UsuarioConfiguracoes usuarioConfiguracoes) {
        this.usuarioConfiguracoes = usuarioConfiguracoes;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO_BASICO")
    public UsuarioBasico getUsuarioBasico() {
        return this.usuarioBasico;
    }

    public void setUsuarioBasico(UsuarioBasico usuarioBasico) {
        this.usuarioBasico = usuarioBasico;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }
}

