/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ClienteFinancContSistemas;
import com.touchcomp.basementor.model.vo.ItemVendaServicosTouch;
import com.touchcomp.basementor.model.vo.MotivoNaoTarifar;
import com.touchcomp.basementor.model.vo.PesquisaEfetuada;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.Projeto;
import com.touchcomp.basementor.model.vo.RelPessoaContatoVenda;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="VENDA_SERVICOS_TOUCH")
public class VendaServicosTouch
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private ClienteFinancContSistemas clienteContSistemas;
    private Short nrParcelas = 0;
    private Short dataVencimentoDif = 0;
    private Double valor = 0.0;
    private Date dataBase;
    private Representante representante;
    private Double percComissao = 0.0;
    private List<ItemVendaServicosTouch> itemVendaServicos = new ArrayList<ItemVendaServicosTouch>();
    private Short tipoVenda = 0;
    private PlanoContaGerencial planoContaGer;
    private String descricao;
    private String observacao;
    private List<RelPessoaContatoVenda> relacionamentoPessoaVenda = new ArrayList<RelPessoaContatoVenda>();
    private Short cancelado = 0;
    private String motivoCancelamento;
    private Short naoTarifar = 0;
    private MotivoNaoTarifar motivoNaoTarifar;
    private Usuario usuarioNaoTarifacao;
    private String observacaoNaoTarifacao;
    private Projeto projeto;
    private Double horasBonificadas = 0.0;
    private Double totalHoras = 0.0;
    private Double totalHorasVenda = 0.0;
    private Double totalHorasUtilizadas = 0.0;
    private Double totalHorasRestantes = 0.0;
    private PesquisaEfetuada pesquisaSatisfacao;
    private Short bonificacaoCapacitacao = 0;
    private Usuario usuarioBonificacaoCapacitacao;
    private MotivoNaoTarifar motivoNaoBonificar;
    private String observacaoBonifCapacitacao;
    private Short comissaoComercial = 0;
    private MotivoNaoTarifar motivoNaoComissao;
    private Usuario usuarioComissaoComercial;
    private String observacaoComsissaoComercial;

    @Id
    @Column(nullable=false, name="ID_VENDA_SERVICOS_TOUCH")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_VENDA_SERVICOS_TOUCH")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @JoinColumn(name="ID_CLIENTE_FIN_CONT_SISTEMAS", foreignKey=@ForeignKey(name="FK_VENDA_SERVICOS_TOUCH_CLI_FIN"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ClienteFinancContSistemas getClienteContSistemas() {
        return this.clienteContSistemas;
    }

    public void setClienteContSistemas(ClienteFinancContSistemas clienteContSistemas) {
        this.clienteContSistemas = clienteContSistemas;
    }

    @Column(name="NR_PARCELAS")
    public Short getNrParcelas() {
        return this.nrParcelas;
    }

    public void setNrParcelas(Short nrParcelas) {
        this.nrParcelas = nrParcelas;
    }

    @Column(name="VALOR", precision=15, scale=2)
    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_BASE")
    public Date getDataBase() {
        return this.dataBase;
    }

    public void setDataBase(Date dataBase) {
        this.dataBase = dataBase;
    }

    @JoinColumn(name="ID_REPRESENTANTE", foreignKey=@ForeignKey(name="FK_VENDA_SER_TOUCH_REPRESENTANT"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Representante getRepresentante() {
        return this.representante;
    }

    public void setRepresentante(Representante representante) {
        this.representante = representante;
    }

    @Column(nullable=false, name="PERC_COMISSAO", precision=15, scale=2)
    public Double getPercComissao() {
        return this.percComissao;
    }

    public void setPercComissao(Double percComissao) {
        this.percComissao = percComissao;
    }

    @OneToMany(mappedBy="vendaServicosTouch")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ItemVendaServicosTouch> getItemVendaServicos() {
        return this.itemVendaServicos;
    }

    public void setItemVendaServicos(List<ItemVendaServicosTouch> itemVendaServicos) {
        this.itemVendaServicos = itemVendaServicos;
    }

    @Column(name="TIPO_VENDA")
    public Short getTipoVenda() {
        return this.tipoVenda;
    }

    public void setTipoVenda(Short tipoVenda) {
        this.tipoVenda = tipoVenda;
    }

    @Column(name="DATA_VENCIMENTO_DIF")
    public Short getDataVencimentoDif() {
        return this.dataVencimentoDif;
    }

    public void setDataVencimentoDif(Short dataVencimentoDif) {
        this.dataVencimentoDif = dataVencimentoDif;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_GER", foreignKey=@ForeignKey(name="FK_VENDA_SERVICOS_TOUCH_PC_GER"))
    public PlanoContaGerencial getPlanoContaGer() {
        return this.planoContaGer;
    }

    public void setPlanoContaGer(PlanoContaGerencial planoContaGer) {
        this.planoContaGer = planoContaGer;
    }

    @Column(name="DESCRICAO", length=300)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="OBSERVACAO", length=500)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="CANCELADO")
    public Short getCancelado() {
        return this.cancelado;
    }

    public void setCancelado(Short cancelado) {
        this.cancelado = cancelado;
    }

    @Column(name="MOTIVO_CANCELAMENTO", length=200)
    public String getMotivoCancelamento() {
        return this.motivoCancelamento;
    }

    public void setMotivoCancelamento(String motivoCancelamento) {
        this.motivoCancelamento = motivoCancelamento;
    }

    @Column(name="NAO_TARIFAR")
    public Short getNaoTarifar() {
        return this.naoTarifar;
    }

    public void setNaoTarifar(Short naoTarifar) {
        this.naoTarifar = naoTarifar;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MOTIVO_NAO_TARIFAR", foreignKey=@ForeignKey(name="FK_AVA_AN_R_PES_CON_MOT_N_TAR"))
    public MotivoNaoTarifar getMotivoNaoTarifar() {
        return this.motivoNaoTarifar;
    }

    public void setMotivoNaoTarifar(MotivoNaoTarifar motivoNaoTarifar) {
        this.motivoNaoTarifar = motivoNaoTarifar;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO_NAO_TARIFACAO")
    public Usuario getUsuarioNaoTarifacao() {
        return this.usuarioNaoTarifacao;
    }

    public void setUsuarioNaoTarifacao(Usuario usuarioNaoTarifacao) {
        this.usuarioNaoTarifacao = usuarioNaoTarifacao;
    }

    @Column(name="OBSERVACAO_NAO_TARIFACAO")
    public String getObservacaoNaoTarifacao() {
        return this.observacaoNaoTarifacao;
    }

    public void setObservacaoNaoTarifacao(String observacaoNaoTarifacao) {
        this.observacaoNaoTarifacao = observacaoNaoTarifacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PROJETO")
    public Projeto getProjeto() {
        return this.projeto;
    }

    public void setProjeto(Projeto projeto) {
        this.projeto = projeto;
    }

    @Column(name="TOTAL_HORAS_UTILIZADAS", updatable=false)
    public Double getTotalHorasUtilizadas() {
        return this.totalHorasUtilizadas;
    }

    public void setTotalHorasUtilizadas(Double totalHorasUtilizadas) {
        this.totalHorasUtilizadas = totalHorasUtilizadas;
    }

    @Column(name="TOTAL_HORAS_RESTANTES", updatable=false)
    public Double getTotalHorasRestantes() {
        return this.totalHorasRestantes;
    }

    public void setTotalHorasRestantes(Double totalHorasRestantes) {
        this.totalHorasRestantes = totalHorasRestantes;
    }

    @Column(name="TOTAL_HORAS", updatable=false)
    public Double getTotalHoras() {
        return this.totalHoras;
    }

    public void setTotalHoras(Double totalHoras) {
        this.totalHoras = totalHoras;
    }

    @OneToMany(mappedBy="vendaServicosTouch")
    @Cascade(value={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.SAVE_UPDATE})
    public List<RelPessoaContatoVenda> getRelacionamentoPessoaVenda() {
        return this.relacionamentoPessoaVenda;
    }

    public void setRelacionamentoPessoaVenda(List<RelPessoaContatoVenda> relacionamentoPessoaVenda) {
        this.relacionamentoPessoaVenda = relacionamentoPessoaVenda;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESQUISA_SATISFACAO")
    public PesquisaEfetuada getPesquisaSatisfacao() {
        return this.pesquisaSatisfacao;
    }

    public void setPesquisaSatisfacao(PesquisaEfetuada pesquisaSatisfacao) {
        this.pesquisaSatisfacao = pesquisaSatisfacao;
    }

    @Column(name="BONIFICACAO_CAPACITACAO")
    public Short getBonificacaoCapacitacao() {
        return this.bonificacaoCapacitacao;
    }

    public void setBonificacaoCapacitacao(Short bonificacaoCapacitacao) {
        this.bonificacaoCapacitacao = bonificacaoCapacitacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO_BONIF_CAPACITACAO")
    public Usuario getUsuarioBonificacaoCapacitacao() {
        return this.usuarioBonificacaoCapacitacao;
    }

    public void setUsuarioBonificacaoCapacitacao(Usuario usuarioBonificacaoCapacitacao) {
        this.usuarioBonificacaoCapacitacao = usuarioBonificacaoCapacitacao;
    }

    @Column(name="OBSERVACAO_BONIF_CAPACITACAO")
    public String getObservacaoBonifCapacitacao() {
        return this.observacaoBonifCapacitacao;
    }

    public void setObservacaoBonifCapacitacao(String observacaoBonifCapacitacao) {
        this.observacaoBonifCapacitacao = observacaoBonifCapacitacao;
    }

    @Column(name="COMISSAO_COMERCIAL")
    public Short getComissaoComercial() {
        return this.comissaoComercial;
    }

    public void setComissaoComercial(Short comissaoComercial) {
        this.comissaoComercial = comissaoComercial;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO_COM_COMERCIAL")
    public Usuario getUsuarioComissaoComercial() {
        return this.usuarioComissaoComercial;
    }

    public void setUsuarioComissaoComercial(Usuario usuarioComissaoComercial) {
        this.usuarioComissaoComercial = usuarioComissaoComercial;
    }

    @Column(name="OBSERVACAO_COMISSAO_COMERCIAL")
    public String getObservacaoComsissaoComercial() {
        return this.observacaoComsissaoComercial;
    }

    public void setObservacaoComsissaoComercial(String observacaoComsissaoComercial) {
        this.observacaoComsissaoComercial = observacaoComsissaoComercial;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MOTIVO_NAO_BONIFICAR")
    public MotivoNaoTarifar getMotivoNaoBonificar() {
        return this.motivoNaoBonificar;
    }

    public void setMotivoNaoBonificar(MotivoNaoTarifar motivoNaoBonificar) {
        this.motivoNaoBonificar = motivoNaoBonificar;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MOTIVO_NAO_COMISSAO")
    public MotivoNaoTarifar getMotivoNaoComissao() {
        return this.motivoNaoComissao;
    }

    public void setMotivoNaoComissao(MotivoNaoTarifar motivoNaoComissao) {
        this.motivoNaoComissao = motivoNaoComissao;
    }

    @Column(name="HORAS_BONIFICADAS")
    public Double getHorasBonificadas() {
        return this.horasBonificadas;
    }

    public void setHorasBonificadas(Double horasBonificadas) {
        this.horasBonificadas = horasBonificadas;
    }

    @Column(name="TOTAL_HORAS_VENDA")
    public Double getTotalHorasVenda() {
        return this.totalHorasVenda;
    }

    public void setTotalHorasVenda(Double totalHorasVenda) {
        this.totalHorasVenda = totalHorasVenda;
    }
}

