/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Coleta;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.TipoPontoControle;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="VIRADA_TROCA_MEDIDOR")
public class ViradaTrocaMedidor
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private Usuario usuario;
    private Equipamento ativo;
    private TipoPontoControle tipoPontoControle;
    private List<Coleta> coletaFinal = new ArrayList<Coleta>();
    private List<Coleta> coletaNovoMedidor = new ArrayList<Coleta>();
    private Timestamp dataHoraColetaFinal;
    private Timestamp dataHoraNovoMedidor;
    private Integer valorColetaFinal = 0;
    private Integer valorColetaNovoMedidor = 0;
    private Short tipo = 0;

    @Id
    @Column(nullable=false, name="ID_VIRADA_TROCA_MEDIDOR")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_VIRADA_TROCA_MEDIDOR")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_VIRADA_TROCA_MEDIDOR_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_VIRADA_TROCA_MEDIDOR_USUARIO"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ATIVO", foreignKey=@ForeignKey(name="FK_VIRADA_TROCA_MEDIDOR_ATIVO"))
    public Equipamento getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Equipamento ativo) {
        this.ativo = ativo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_PONTO_CONTROLE", foreignKey=@ForeignKey(name="FK_VIRADA_TROCA_MEDIDOR_TP_CONT"))
    public TipoPontoControle getTipoPontoControle() {
        return this.tipoPontoControle;
    }

    public void setTipoPontoControle(TipoPontoControle tipoPontoControle) {
        this.tipoPontoControle = tipoPontoControle;
    }

    @OneToMany
    @Cascade(value={CascadeType.MERGE, CascadeType.SAVE_UPDATE, CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    @JoinTable(name="VIR_TRO_COLETA_FINAL", joinColumns={@JoinColumn(name="ID_VIRADA_TROCA_MEDIDOR")}, inverseJoinColumns={@JoinColumn(name="ID_COLETA_FINAL")})
    public List<Coleta> getColetaFinal() {
        return this.coletaFinal;
    }

    public void setColetaFinal(List<Coleta> coletaFinal) {
        this.coletaFinal = coletaFinal;
    }

    @OneToMany
    @Cascade(value={CascadeType.MERGE, CascadeType.SAVE_UPDATE, CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    @JoinTable(name="VIR_TRO_COLETA_NOVO_MEDIDOR", joinColumns={@JoinColumn(name="ID_VIRADA_TROCA_MEDIDOR")}, inverseJoinColumns={@JoinColumn(name="ID_COLETA_NOVO_MEDIDOR")})
    public List<Coleta> getColetaNovoMedidor() {
        return this.coletaNovoMedidor;
    }

    public void setColetaNovoMedidor(List<Coleta> coletaNovoMedidor) {
        this.coletaNovoMedidor = coletaNovoMedidor;
    }

    @Column(name="DATA_COLETA_FINAL")
    public Timestamp getDataHoraColetaFinal() {
        return this.dataHoraColetaFinal;
    }

    public void setDataHoraColetaFinal(Timestamp dataHoraColetaFinal) {
        this.dataHoraColetaFinal = dataHoraColetaFinal;
    }

    @Column(name="DATA_COLETA_NOVO_MEDIDOR")
    public Timestamp getDataHoraNovoMedidor() {
        return this.dataHoraNovoMedidor;
    }

    public void setDataHoraNovoMedidor(Timestamp dataHoraNovoMedidor) {
        this.dataHoraNovoMedidor = dataHoraNovoMedidor;
    }

    @Column(name="VALOR_COLETA_FINAL")
    public Integer getValorColetaFinal() {
        return this.valorColetaFinal;
    }

    public void setValorColetaFinal(Integer valorColetaFinal) {
        this.valorColetaFinal = valorColetaFinal;
    }

    @Column(name="VALOR_COLETA_NOVO_MEDIDOR")
    public Integer getValorColetaNovoMedidor() {
        return this.valorColetaNovoMedidor;
    }

    public void setValorColetaNovoMedidor(Integer valorColetaNovoMedidor) {
        this.valorColetaNovoMedidor = valorColetaNovoMedidor;
    }

    @Column(name="TIPO")
    public Short getTipo() {
        return this.tipo;
    }

    public void setTipo(Short tipo) {
        this.tipo = tipo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getAtivo()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

