/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstSinteticoAnalitico;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.WmsEnderecoGradeCor;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="WMS_ENDERECO")
public class WmsEndereco
implements InterfaceVO {
    @Id
    @Column(name="ID_WMS_ENDERECO", nullable=false, unique=true)
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_WMS_ENDERECO")
    private Long identificador;
    @Column(name="CODIGO", nullable=true, unique=false, length=255)
    private String codigo;
    @Column(name="CODIGO_MASCARA", nullable=true, unique=false, length=255)
    private String codigoMascara;
    @Column(name="DESCRICAO", nullable=true, unique=false, length=255)
    private String descricao;
    @Column(name="PESO", nullable=true, unique=false, precision=15, scale=2)
    private Double peso = 0.0;
    @Column(name="VOLUME", nullable=true, unique=false, precision=15, scale=2)
    private Double volume = 0.0;
    @Column(name="INDISPONIVEL", nullable=true, unique=false)
    private Integer indisponivel = 0;
    @OneToMany(mappedBy="enderecoPai", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    private List<WmsEndereco> children = new LinkedList<WmsEndereco>();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ENDERECO_PAI", foreignKey=@ForeignKey(name="FK_WMS_ENDERECO_WMS_WMS_END"), unique=false)
    private WmsEndereco enderecoPai;
    @Column(name="nivel", nullable=false)
    private Short nivel = 1;
    @OneToMany(mappedBy="wmsEndereco", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<WmsEnderecoGradeCor> gradesCores = new LinkedList<WmsEnderecoGradeCor>();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_ESTOQUE", foreignKey=@ForeignKey(name="FK_WMS_ENDERECO_WMS_CENT_EST"), unique=false)
    private CentroEstoque centroEstoque;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_ESTOQUE_SAIDA", foreignKey=@ForeignKey(name="FK_WMS_ENDERECO_WMS_CENT_E_SAI"), unique=false)
    private CentroEstoque centroEstoqueSaida;
    @Column(name="DISTANCIA")
    private Double distancia = 0.0;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_WMS_ENDERECO_WMS_EMPRESA"), unique=false)
    private Empresa empresa;
    @Column(name="SINTETICO_ANALITICO", nullable=false)
    private Short sinteticoAnalitico = EnumConstSinteticoAnalitico.ANALITICO.getValue();

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Generated
    public Long getIdentificador() {
        return this.identificador;
    }

    @Generated
    public String getCodigo() {
        return this.codigo;
    }

    @Generated
    public String getCodigoMascara() {
        return this.codigoMascara;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Double getPeso() {
        return this.peso;
    }

    @Generated
    public Double getVolume() {
        return this.volume;
    }

    @Generated
    public Integer getIndisponivel() {
        return this.indisponivel;
    }

    @Generated
    public List<WmsEndereco> getChildren() {
        return this.children;
    }

    @Generated
    public WmsEndereco getEnderecoPai() {
        return this.enderecoPai;
    }

    @Generated
    public Short getNivel() {
        return this.nivel;
    }

    @Generated
    public List<WmsEnderecoGradeCor> getGradesCores() {
        return this.gradesCores;
    }

    @Generated
    public CentroEstoque getCentroEstoque() {
        return this.centroEstoque;
    }

    @Generated
    public CentroEstoque getCentroEstoqueSaida() {
        return this.centroEstoqueSaida;
    }

    @Generated
    public Double getDistancia() {
        return this.distancia;
    }

    @Generated
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Generated
    public Short getSinteticoAnalitico() {
        return this.sinteticoAnalitico;
    }

    @Generated
    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    @Generated
    public void setCodigoMascara(String codigoMascara) {
        this.codigoMascara = codigoMascara;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setPeso(Double peso) {
        this.peso = peso;
    }

    @Generated
    public void setVolume(Double volume) {
        this.volume = volume;
    }

    @Generated
    public void setIndisponivel(Integer indisponivel) {
        this.indisponivel = indisponivel;
    }

    @Generated
    public void setChildren(List<WmsEndereco> children) {
        this.children = children;
    }

    @Generated
    public void setEnderecoPai(WmsEndereco enderecoPai) {
        this.enderecoPai = enderecoPai;
    }

    @Generated
    public void setNivel(Short nivel) {
        this.nivel = nivel;
    }

    @Generated
    public void setGradesCores(List<WmsEnderecoGradeCor> gradesCores) {
        this.gradesCores = gradesCores;
    }

    @Generated
    public void setCentroEstoque(CentroEstoque centroEstoque) {
        this.centroEstoque = centroEstoque;
    }

    @Generated
    public void setCentroEstoqueSaida(CentroEstoque centroEstoqueSaida) {
        this.centroEstoqueSaida = centroEstoqueSaida;
    }

    @Generated
    public void setDistancia(Double distancia) {
        this.distancia = distancia;
    }

    @Generated
    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Generated
    public void setSinteticoAnalitico(Short sinteticoAnalitico) {
        this.sinteticoAnalitico = sinteticoAnalitico;
    }
}

