/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ComunicadoProducao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ImplantacaoSaldos;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.TransferenciaCentroEstoque;
import com.touchcomp.basementor.model.vo.WmsEntradaEstoqueItem;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import lombok.Generated;

@Entity
@Table(name="WMS_ENTRADA_ESTOQUE")
public class WmsEntradaEstoque
implements InterfaceVO {
    @Id
    @Column(name="ID_WMS_ENTRADA_ESTOQUE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_WMS_ENTRADA_ESTOQUE")
    private Long identificador;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO", nullable=true, unique=false)
    private Date dataCadastro;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_ATUALIZACAO", nullable=true, unique=false)
    private Date dataAtualizacao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", nullable=true, unique=false)
    private Empresa empresa;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ENTRADA", nullable=true, unique=false)
    private Date dataEntrada;
    @Column(name="OBSERVACAO", nullable=true, unique=false, length=500)
    private String observacao;
    @OneToMany(mappedBy="wmsEntradaEstoque", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<WmsEntradaEstoqueItem> itens = new LinkedList<WmsEntradaEstoqueItem>();
    @Column(name="PESO_TOTAL", scale=15, precision=6)
    private Double pesoTotal = 0.0;
    @Column(name="VOLUME_TOTAL", scale=15, precision=6)
    private Double volumeTotal = 0.0;
    @Column(name="QUANTIDADE_TOTAL", scale=15, precision=6)
    private Double quantidadeTotal = 0.0;
    @Column(name="DESCRICAO", length=500)
    private String descricao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NOTA_FISCAL_PROPRIA")
    private NotaFiscalPropria notaFiscalPropria;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NOTA_FISCAL_TERCEIROS")
    private NotaFiscalTerceiros notaFiscalTerceiros;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COMUNICADO_PRODUCAO")
    private ComunicadoProducao comunicadoProducao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_IMPLANTACAO_SALDOS")
    private ImplantacaoSaldos implantacaoSaldos;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TRANSF_CENTRO_EST_ENTRADA")
    private TransferenciaCentroEstoque transferenciaEstEntrada;
    @Column(name="EFETIVAR_ENTRADA")
    private Short efetivarEntrada = 0;

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Generated
    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Generated
    public void setDataAtualizacao(Date dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Generated
    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Generated
    public void setDataEntrada(Date dataEntrada) {
        this.dataEntrada = dataEntrada;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setItens(List<WmsEntradaEstoqueItem> itens) {
        this.itens = itens;
    }

    @Generated
    public void setPesoTotal(Double pesoTotal) {
        this.pesoTotal = pesoTotal;
    }

    @Generated
    public void setVolumeTotal(Double volumeTotal) {
        this.volumeTotal = volumeTotal;
    }

    @Generated
    public void setQuantidadeTotal(Double quantidadeTotal) {
        this.quantidadeTotal = quantidadeTotal;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setNotaFiscalPropria(NotaFiscalPropria notaFiscalPropria) {
        this.notaFiscalPropria = notaFiscalPropria;
    }

    @Generated
    public void setNotaFiscalTerceiros(NotaFiscalTerceiros notaFiscalTerceiros) {
        this.notaFiscalTerceiros = notaFiscalTerceiros;
    }

    @Generated
    public void setComunicadoProducao(ComunicadoProducao comunicadoProducao) {
        this.comunicadoProducao = comunicadoProducao;
    }

    @Generated
    public void setImplantacaoSaldos(ImplantacaoSaldos implantacaoSaldos) {
        this.implantacaoSaldos = implantacaoSaldos;
    }

    @Generated
    public void setTransferenciaEstEntrada(TransferenciaCentroEstoque transferenciaEstEntrada) {
        this.transferenciaEstEntrada = transferenciaEstEntrada;
    }

    @Generated
    public void setEfetivarEntrada(Short efetivarEntrada) {
        this.efetivarEntrada = efetivarEntrada;
    }

    @Generated
    public Long getIdentificador() {
        return this.identificador;
    }

    @Generated
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Generated
    public Date getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Generated
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Generated
    public Date getDataEntrada() {
        return this.dataEntrada;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public List<WmsEntradaEstoqueItem> getItens() {
        return this.itens;
    }

    @Generated
    public Double getPesoTotal() {
        return this.pesoTotal;
    }

    @Generated
    public Double getVolumeTotal() {
        return this.volumeTotal;
    }

    @Generated
    public Double getQuantidadeTotal() {
        return this.quantidadeTotal;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public NotaFiscalPropria getNotaFiscalPropria() {
        return this.notaFiscalPropria;
    }

    @Generated
    public NotaFiscalTerceiros getNotaFiscalTerceiros() {
        return this.notaFiscalTerceiros;
    }

    @Generated
    public ComunicadoProducao getComunicadoProducao() {
        return this.comunicadoProducao;
    }

    @Generated
    public ImplantacaoSaldos getImplantacaoSaldos() {
        return this.implantacaoSaldos;
    }

    @Generated
    public TransferenciaCentroEstoque getTransferenciaEstEntrada() {
        return this.transferenciaEstEntrada;
    }

    @Generated
    public Short getEfetivarEntrada() {
        return this.efetivarEntrada;
    }
}

