/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementor.model.vo.WmsPedido;
import com.touchcomp.basementor.model.vo.WmsPedidoMapaSep;
import com.touchcomp.basementor.model.vo.WmsSaidaEstoque;
import com.touchcomp.basementor.model.vo.WmsSeparacaoPedidoEmb;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import lombok.Generated;

@Entity
@Table(name="WMS_SEPARACAO_PEDIDO")
public class WmsSeparacaoPedido
implements InterfaceVO {
    @Id
    @Column(name="ID_WMS_SEPARACAO_PEDIDO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_WMS_SEPARACAO_PEDIDO")
    private Long identificador;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO", nullable=true, unique=false)
    private Date dataCadastro;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_SEPARACAO", nullable=true, unique=false)
    private Date dataSeparacao;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_SAIDA", nullable=true, unique=false)
    private Date dataSaida;
    @Version
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_ATUALIZACAO", nullable=true, unique=false)
    private Date dataAtualizacao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", nullable=true, unique=false, foreignKey=@ForeignKey(name="FK_WMS_SEP_PED_EMPRESA"))
    private Empresa empresa;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO_SEPARACAO", nullable=true, unique=false, foreignKey=@ForeignKey(name="FK_WMS_SEP_PED_USU_SEP"))
    private Usuario usuarioSeparacao;
    @Column(name="QUANTIDADE_TOTAL", nullable=true, unique=false, precision=15, scale=2)
    private Double quantidadeTotal = 0.0;
    @Column(name="VOLUME_TOTAL", nullable=true, unique=false, precision=15, scale=2)
    private Double volumeTotal = 0.0;
    @Column(name="PESO_TOTAL", nullable=true, unique=false, precision=15, scale=2)
    private Double pesoTotal = 0.0;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PEDIDO_WMS", nullable=true, unique=false, foreignKey=@ForeignKey(name="FK_WMS_SEP_PED_WMS_PEDIDO"))
    private WmsPedido pedidoWms;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_SAIDA_ESTOQUE_WMS", nullable=true, unique=false, foreignKey=@ForeignKey(name="FK_WMS_SEP_PED_WMS_PEDIDO"))
    private WmsSaidaEstoque wmsSaidaEstoque;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="separacaoPedido", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<WmsSeparacaoPedidoEmb> embalagens = new LinkedList<WmsSeparacaoPedidoEmb>();
    @Column(name="QUANTIDADE_TOTAL_CONF", nullable=true, unique=false, precision=15, scale=3)
    private Double quantidadeTotalConf = 0.0;
    @Column(name="VOLUME_TOTAL_CONF", nullable=true, unique=false, precision=15, scale=3)
    private Double volumeTotaConf = 0.0;
    @Column(name="PESO_TOTAL_CONF", nullable=true, unique=false)
    private Double pesoTotalConf = 0.0;
    @Column(name="PERC_CONFERIDO", nullable=true, unique=false, precision=15, scale=3)
    private Double percConferido = 0.0;
    @Column(name="DESCRICAO", length=500)
    private String descricao;
    @Column(name="CONFERIDO_INTEGRALMENTE")
    private Short conferidoIntegralmente = 0;
    @Column(name="CONFERENCIA_FINALIZADA")
    private Short conferenciaFinalizada = 0;
    @Column(name="OBSERVACAO")
    private String observacao;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="ID_WMS_PEDIDO_MAPA_SEP")
    private WmsPedidoMapaSep mapaSeparacao;

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1} / {2}", (Object[])new Object[]{this.getIdentificador(), this.getDataSeparacao(), this.getUsuarioSeparacao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Generated
    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Generated
    public void setDataSeparacao(Date dataSeparacao) {
        this.dataSeparacao = dataSeparacao;
    }

    @Generated
    public void setDataSaida(Date dataSaida) {
        this.dataSaida = dataSaida;
    }

    @Generated
    public void setDataAtualizacao(Date dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Generated
    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Generated
    public void setUsuarioSeparacao(Usuario usuarioSeparacao) {
        this.usuarioSeparacao = usuarioSeparacao;
    }

    @Generated
    public void setQuantidadeTotal(Double quantidadeTotal) {
        this.quantidadeTotal = quantidadeTotal;
    }

    @Generated
    public void setVolumeTotal(Double volumeTotal) {
        this.volumeTotal = volumeTotal;
    }

    @Generated
    public void setPesoTotal(Double pesoTotal) {
        this.pesoTotal = pesoTotal;
    }

    @Generated
    public void setPedidoWms(WmsPedido pedidoWms) {
        this.pedidoWms = pedidoWms;
    }

    @Generated
    public void setWmsSaidaEstoque(WmsSaidaEstoque wmsSaidaEstoque) {
        this.wmsSaidaEstoque = wmsSaidaEstoque;
    }

    @Generated
    public void setEmbalagens(List<WmsSeparacaoPedidoEmb> embalagens) {
        this.embalagens = embalagens;
    }

    @Generated
    public void setQuantidadeTotalConf(Double quantidadeTotalConf) {
        this.quantidadeTotalConf = quantidadeTotalConf;
    }

    @Generated
    public void setVolumeTotaConf(Double volumeTotaConf) {
        this.volumeTotaConf = volumeTotaConf;
    }

    @Generated
    public void setPesoTotalConf(Double pesoTotalConf) {
        this.pesoTotalConf = pesoTotalConf;
    }

    @Generated
    public void setPercConferido(Double percConferido) {
        this.percConferido = percConferido;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setConferidoIntegralmente(Short conferidoIntegralmente) {
        this.conferidoIntegralmente = conferidoIntegralmente;
    }

    @Generated
    public void setConferenciaFinalizada(Short conferenciaFinalizada) {
        this.conferenciaFinalizada = conferenciaFinalizada;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setMapaSeparacao(WmsPedidoMapaSep mapaSeparacao) {
        this.mapaSeparacao = mapaSeparacao;
    }

    @Generated
    public Long getIdentificador() {
        return this.identificador;
    }

    @Generated
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Generated
    public Date getDataSeparacao() {
        return this.dataSeparacao;
    }

    @Generated
    public Date getDataSaida() {
        return this.dataSaida;
    }

    @Generated
    public Date getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Generated
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Generated
    public Usuario getUsuarioSeparacao() {
        return this.usuarioSeparacao;
    }

    @Generated
    public Double getQuantidadeTotal() {
        return this.quantidadeTotal;
    }

    @Generated
    public Double getVolumeTotal() {
        return this.volumeTotal;
    }

    @Generated
    public Double getPesoTotal() {
        return this.pesoTotal;
    }

    @Generated
    public WmsPedido getPedidoWms() {
        return this.pedidoWms;
    }

    @Generated
    public WmsSaidaEstoque getWmsSaidaEstoque() {
        return this.wmsSaidaEstoque;
    }

    @Generated
    public List<WmsSeparacaoPedidoEmb> getEmbalagens() {
        return this.embalagens;
    }

    @Generated
    public Double getQuantidadeTotalConf() {
        return this.quantidadeTotalConf;
    }

    @Generated
    public Double getVolumeTotaConf() {
        return this.volumeTotaConf;
    }

    @Generated
    public Double getPesoTotalConf() {
        return this.pesoTotalConf;
    }

    @Generated
    public Double getPercConferido() {
        return this.percConferido;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public Short getConferidoIntegralmente() {
        return this.conferidoIntegralmente;
    }

    @Generated
    public Short getConferenciaFinalizada() {
        return this.conferenciaFinalizada;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public WmsPedidoMapaSep getMapaSeparacao() {
        return this.mapaSeparacao;
    }
}

